/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.contest;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.cache.CachedFKReference;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntityType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="contest_entity")
public class ContestEntity
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Contest> contest = new CachedFKReference<Contest>(Contest.class);
    private ContestEntityType entityType;
    private long entityId = 0L;
    private int sequence = 0;
    private Color backgroundColor;
    private Color foregroundColor;

    @Deprecated
    public ContestEntity() {
    }

    protected ContestEntity(Contest thatContest, ContestEntityType entityType, long entityId) {
        if (thatContest == null || entityType == null) {
            throw new IllegalArgumentException("The contest object and the contest entity type CANNOT be NULL!");
        }
        this.contest.set(thatContest);
        this.entityType = entityType;
        this.entityId = entityId;
    }

    @Column(name="entity_id")
    public long getEntityId() {
        return this.entityId;
    }

    protected void setEntityId(long newEntityId) {
        this.entityId = newEntityId;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="entity_type")
    public ContestEntityType getEntityType() {
        return this.entityType;
    }

    @ManyToOne
    @JoinColumn(name="fk_contest")
    public Contest getContest() {
        return this.contest.get();
    }

    protected void setContest(Contest newContest) {
        this.contest.set(newContest);
    }

    protected void setEntityType(ContestEntityType entityType) {
        this.entityType = entityType;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_background")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color newBackgroundColor) {
        this.backgroundColor = newBackgroundColor;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_foreground")
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color newForegroundColor) {
        this.foregroundColor = newForegroundColor;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Contest> CONTEST;
        public PropertiedObject.Property<ContestEntityType> ENTITY_TYPE;
        public PropertiedObject.Property<Long> ENTITY_ID;
        public PropertiedObject.Property<Integer> SEQUENCE;
        public PropertiedObject.Property<Color> BACKGROUND_COLOR;
        public PropertiedObject.Property<Color> FOREGROUND_COLOR;
    }
}

