/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.contest;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.combos.InventoryCombo;

public enum ContestEntityType {
    Category(InventoryCategory.class, "C"),
    Section(InventoryGroup.class, "S"),
    Item(InventoryItem.class, "I"),
    ItemUnit(InventoryItemUnit.class, "I"),
    Combo(InventoryCombo.class, "CO"),
    OptionGroup(InventoryOptionGroup.class, "OG"),
    Option(InventoryOption.class, "O"),
    PlusGroup(InventoryAddGroup.class, "PG"),
    Plus(InventoryAdd.class, "P");

    private static final Map<Class, ContestEntityType> lookup;
    private final Class clazz;
    private final String shortName;

    private ContestEntityType(Class clazz, String shortName) {
        this.clazz = clazz;
        this.shortName = shortName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static ContestEntityType getEntityType(Class clazz) {
        ContestEntityType entityType = lookup.get(clazz);
        if (entityType != null) {
            return entityType;
        }
        throw new IllegalArgumentException();
    }

    static {
        lookup = new HashMap<Class, ContestEntityType>();
        for (ContestEntityType entityType : EnumSet.allOf(ContestEntityType.class)) {
            lookup.put(entityType.getClazz(), entityType);
        }
    }
}

