/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.contest;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestEntity;
import ordermate.database.contest.ContestEntityType;
import ordermate.database.queries.contest.ContestQueries;

public enum ContestHelper {
    INSTANCE;


    public ContestEntity getContestEntity(Contest contest, Long businessObjectID, ContestEntityType entityType) {
        return PersistenceManager.getObject(ContestEntity.class, ContestQueries.getContestEntity(contest, entityType, businessObjectID).toString());
    }

    public <T> List<T> getBusinessObjects(Contest contest, ContestEntityType entityType) {
        ArrayList<Long> entityIDs = new ArrayList<Long>();
        for (ContestEntity existentEntity : contest.getEntities()) {
            if (!entityType.equals((Object)existentEntity.getEntityType())) continue;
            entityIDs.add(existentEntity.getEntityId());
        }
        ObjectQuery oQuery = new ObjectQuery().select(entityType.getClazz()).active(entityType.getClazz()).whereIn("ID", entityIDs);
        return PersistenceManager.getObjectList(entityType.getClazz(), oQuery.toString());
    }

    public Contest getWaiterMateDisplayableContest() {
        List<Contest> contests = PersistenceManager.getObjectList(Contest.class, ContestQueries.getWaiterMateDisplayableContest().toString());
        if (contests != null && !contests.isEmpty()) {
            return contests.get(0);
        }
        return null;
    }
}

