/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.course;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.misc.Course;
import ordermate.database.sales.TableAccount;

public class SalesAccountCourse
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<TableAccount> tableAccount;
    private Reference<Course> course;
    private Date lastPrintedTime;
    private CoursePrintStatus coursePrintStatus;

    public SalesAccountCourse() {
        this.tableAccount = this.createReference(SalesAccountCourse.Properties.TABLE_ACCOUNT);
        this.course = this.createReference(SalesAccountCourse.Properties.COURSE);
        this.lastPrintedTime = null;
        this.coursePrintStatus = CoursePrintStatus.PRINT;
    }

    public Date getLastPrintedTime() {
        return this.lastPrintedTime;
    }

    public void setLastPrintedTime(Date lastPrintedTime) {
        this.lastPrintedTime = lastPrintedTime;
    }

    public TableAccount getTableAccount() {
        return this.tableAccount.get();
    }

    public void setTableAccount(TableAccount account) {
        this.tableAccount.set(account);
    }

    public Course getCourse() {
        return this.course.get();
    }

    public void setCourse(Course course) {
        this.course.set(course);
    }

    public CoursePrintStatus getCoursePrintStatus() {
        return this.coursePrintStatus;
    }

    public void setCoursePrintStatus(CoursePrintStatus coursePrintStatus) {
        this.coursePrintStatus = coursePrintStatus;
        this.save();
    }

    public boolean isCoursePrintOnHold() {
        return this.coursePrintStatus.equals((Object)CoursePrintStatus.HOLD);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<TableAccount> TABLE_ACCOUNT;
        public PropertiedObject.Property<Course> COURSE;
        public PropertiedObject.Property<Date> LAST_PRINTED_TIME;
        public PropertiedObject.Property<CoursePrintStatus> COURSE_PRINT_STATUS;
    }
}

