/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.dbconstants;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SystemState
extends PersistentEnumeration {
    public static final String COLUMN_NAME = "system_state";
    public static final String ACTIVE = "ACTIVE";
    public static final String INACTIVE = "INACTIVE";
    public static final String MOVED = "MOVED";
    public static final String DELETED = "DELETED";
    public static final String DELETED_WASTED = "DELETED_WASTED";
    public static final String CLONED = "CLONED";
    public static final String DEFAULT_ENUM = "enum('ACTIVE','DELETED')";
    public static final SystemState ACTIVE_STATE = new SystemState("ACTIVE");
    public static final SystemState DELETED_STATE = new SystemState("DELETED");
    public static final SystemState INACTIVE_STATE = new SystemState("INACTIVE");
    public static final SystemState MOVED_STATE = new SystemState("MOVED");
    public static final SystemState DELETED_WASTED_STATE = new SystemState("DELETED_WASTED");
    public static final SystemState CLONED_STATE = new SystemState("CLONED");
    public static final Map<String, SystemState> register = SystemState.buildRegister(ACTIVE_STATE, DELETED_STATE, INACTIVE_STATE, MOVED_STATE, DELETED_WASTED_STATE, DELETED_WASTED_STATE, CLONED_STATE);
    public static final Map<String, SystemState> defaultRegister;
    public static final Map<String, SystemState> registerWithInactiveState;
    public static final Map<String, SystemState> defaultEditableSystemStates;
    public static final List<String> defaultSystemStates;

    public String getSystemState() {
        return this.toString();
    }

    public static SystemState parseSystemState(String newState) {
        SystemState state = register.get(newState);
        if (state != null) {
            return state;
        }
        throw new IllegalArgumentException("Attempt to set system state to invalid string " + newState);
    }

    public static boolean isActive(PersistentObject obj) {
        if (obj.getProperties().hasProperty("systemState")) {
            String sysState = obj.getPropertyValue(new PropertiedObject.Property(obj.getClass(), "systemState")) + "";
            return sysState.equals(ACTIVE);
        }
        return true;
    }

    public static String getSQLColumnTypeDefinition() {
        return DEFAULT_ENUM;
    }

    public static String getSQLColumnDefinition() {
        return String.format("system_state %s NOT NULL DEFAULT 'ACTIVE'", SystemState.getSQLColumnTypeDefinition());
    }

    private SystemState(String newLabel) {
        super(newLabel);
    }

    static {
        PersistentEnumeration.UnmodifiableMapBuilder<SystemState> builder = new PersistentEnumeration.UnmodifiableMapBuilder<SystemState>();
        builder.put(ACTIVE_STATE);
        builder.put(DELETED_STATE);
        defaultRegister = builder.getMap();
        builder = new PersistentEnumeration.UnmodifiableMapBuilder();
        builder.put(ACTIVE_STATE);
        builder.put(INACTIVE_STATE);
        builder.put(DELETED_STATE);
        registerWithInactiveState = builder.getMap();
        builder = new PersistentEnumeration.UnmodifiableMapBuilder();
        builder.put(ACTIVE_STATE);
        builder.put(INACTIVE_STATE);
        defaultEditableSystemStates = builder.getMap();
        defaultSystemStates = Collections.unmodifiableList(Arrays.asList(ACTIVE_STATE.toString(), INACTIVE_STATE.toString()));
    }
}

