/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.debtors;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.User;

public class DebtorTransactionManager {
    private final Payable targetPayable;
    private final Map<AbstractDebtor, List<FinanceTransaction>> transferMap;
    private final GuiHandler handler;
    private boolean finalised = false;

    public DebtorTransactionManager(Payable payable, GuiHandler handler) {
        this.targetPayable = payable;
        this.transferMap = new HashMap<AbstractDebtor, List<FinanceTransaction>>();
        this.handler = handler;
    }

    public List<FinanceTransaction> transferDebtorPaymentsToPayable(List<DebtorPayment> payments, AbstractDebtor debtor, EventContext context) {
        User user = context.getUser();
        this.checkFinalised();
        ArrayList<FinanceTransaction> txns = new ArrayList<FinanceTransaction>();
        if (debtor.isLocked(user) || debtor.lock(user)) {
            if (this.transferMap.get(debtor) == null) {
                this.transferMap.put(debtor, new ArrayList());
            }
            for (DebtorPayment payment : payments) {
                FinanceTransaction txn = payment.getFinanceTransaction();
                txn.prepareForSave(context);
                if ("ACTIVE".equals(txn.getSystemState()) && !payment.hasDebtorSale()) {
                    try {
                        payment.setAmount(Price.ZERO_DOLLAR);
                        FinanceTransaction transferredTxn = txn.transfer();
                        if (transferredTxn instanceof DebtorAdjustmentTransaction) {
                            OrderMate.LOG.warn("DebtorAdjustmentTransaction Transfer to surcharge");
                            FinanceSurchargeCalculator.applySurcharge(this.targetPayable, transferredTxn.getSubType(), transferredTxn.getPaid().negate(), new EventContext(user));
                        } else {
                            txns.add(transferredTxn);
                            this.targetPayable.addFinanceTransaction(transferredTxn);
                        }
                        this.transferMap.get(debtor).remove(transferredTxn);
                        this.transferMap.get(debtor).add(transferredTxn);
                    }
                    catch (IllegalArgumentException ex) {
                        this.handler.displayOkDialog("Cannot Transfer", "The transaction for " + txn.getPaid() + " cannot be transferred");
                    }
                    continue;
                }
                this.handler.displayOkDialog("Cannot Transfer", "The transaction on this account for " + payment.getAmount() + " has been used to partly pay for another sale.");
            }
        } else {
            this.handler.displayOkDialog("Debtor in use", "The debtor cannot be locked to transfer payments.");
        }
        return txns;
    }

    public boolean returnTransactionBackOnDebtor(FinanceTransaction toReturn, User user) {
        this.checkFinalised();
        DebtorPayment payment = PersistenceManager.getObject(DebtorPayment.class, Query.select(DebtorPayment.class).equals(DebtorPayment.Properties.FINANCE_TRANSACTION, toReturn.getMovedTransaction()).toString());
        AbstractDebtor debtor = payment.getDebtor();
        if (!debtor.isActive()) {
            this.handler.displayOkDialog("Debtor Deleted", "The payment cannot be returned to a deleted debtor.");
            return false;
        }
        if (debtor.isLocked(user) || debtor.lock(user)) {
            if (!this.isCurrentlyBeingTransferred(toReturn)) {
                List<FinanceTransaction> txns;
                if (this.transferMap.get(debtor) == null) {
                    this.transferMap.put(debtor, new ArrayList());
                }
                if (!(txns = this.transferMap.get(debtor)).contains(toReturn)) {
                    this.targetPayable.removeFinanceTransaction(toReturn);
                    txns.add(toReturn);
                }
            } else {
                OrderMate.LOG.info("Reverting transferred transaction back to debtor :" + debtor);
                FinanceTransaction originalTransaction = toReturn.revertTransfer();
                this.targetPayable.removeFinanceTransaction(toReturn);
                List<FinanceTransaction> txns = this.transferMap.get(debtor);
                if (txns != null) {
                    txns.remove(toReturn);
                    this.checkForSurcharge(toReturn, user);
                    if (txns.isEmpty()) {
                        debtor.unlock();
                        this.transferMap.remove(debtor);
                    }
                }
            }
            debtor.updateTotalDue();
            debtor.save();
            return true;
        }
        this.handler.displayOkDialog("Debtor Locked", "The debtor cannot be locked. Please stop using the debtor and try again.");
        return false;
    }

    private void checkForSurcharge(FinanceTransaction removingTransaction, User user) {
        if (!removingTransaction.getSurcharge().isZero()) {
            FinanceSurchargeCalculator.removeSurcharge(this.targetPayable, removingTransaction.getSurcharge(), new EventContext(user), removingTransaction.getSubType());
        }
    }

    public void commitChanges(EventContext context) {
        this.checkFinalised();
        for (AbstractDebtor debtor : this.transferMap.keySet()) {
            for (FinanceTransaction nextTxn : this.transferMap.get(debtor)) {
                if (this.isCurrentlyBeingTransferred(nextTxn)) {
                    TerminalEventLog.logTransactionTransferred(nextTxn, debtor.getLabel(), this.targetPayable.getLabel(), context);
                    nextTxn.getMovedTransaction().saveChild();
                    continue;
                }
                FinanceTransaction originalTransaction = nextTxn.revertTransfer();
                this.targetPayable.removeFinanceTransaction(nextTxn);
                TerminalEventLog.logPaymentDeleted(context, nextTxn);
                originalTransaction.saveChild();
                DebtorPayment payment = PersistenceManager.getObject(DebtorPayment.class, Query.select(DebtorPayment.class).equals(DebtorPayment.Properties.FINANCE_TRANSACTION, originalTransaction).toString());
                if (payment != null) {
                    payment.setAmount(originalTransaction.getPaid());
                }
                debtor.addUnsettlePayment(payment);
            }
            debtor.updateTotalDue();
            debtor.save();
        }
        this.unlockDebtors();
    }

    public void cancelChanges() {
        for (List<FinanceTransaction> txns : this.transferMap.values()) {
            for (FinanceTransaction txn : txns) {
                if (this.isCurrentlyBeingTransferred(txn)) {
                    txn.revertTransfer();
                    this.targetPayable.removeFinanceTransaction(txn);
                    continue;
                }
                txn.setSystemState("ACTIVE");
                if (this.targetPayable.getFinanceTransactions().contains(txn)) continue;
                this.targetPayable.addFinanceTransaction(txn);
            }
        }
        this.unlockDebtors();
    }

    private void unlockDebtors() {
        for (AbstractDebtor debtor : this.transferMap.keySet()) {
            debtor.unlock();
        }
        this.transferMap.clear();
        this.finalised = true;
    }

    public boolean isTransferring(DebtorPayment payment, AbstractDebtor debtor) {
        List<FinanceTransaction> txns = this.transferMap.get(debtor);
        if (txns != null) {
            for (FinanceTransaction nextTransfer : txns) {
                if (!payment.getFinanceTransaction().equals(nextTransfer.getMovedTransaction())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCurrentlyBeingTransferred(FinanceTransaction txn) {
        return !txn.isPersistent();
    }

    void checkFinalised() {
        if (this.finalised) {
            throw new IllegalStateException("Cannot use a DebtorTransactionManager after it has been finalised. Create a new one");
        }
    }

    public Collection<AbstractDebtor> getTransferringDebtors() {
        return this.transferMap.keySet();
    }

    public List<FinanceTransaction> getTransferringTransactions() {
        ArrayList<FinanceTransaction> txns = new ArrayList<FinanceTransaction>();
        for (List<FinanceTransaction> nextTxn : this.transferMap.values()) {
            txns.addAll(nextTxn);
        }
        return txns;
    }

    public Payable getPayable() {
        return this.targetPayable;
    }

    public boolean isFinalised() {
        return this.finalised;
    }
}

