/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.delivery;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import java.util.Objects;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.Policy;
import ordermate.database.misc.SystemProperty;

public class StreetDirectoryReference
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String streetName;
    private String streetType;
    private String suburb;
    private String postcode;
    private String page;
    private String gridPosition;
    private Reference<DeliveryZone> zone;
    private transient String label;
    private String systemState;

    public StreetDirectoryReference() {
        this.zone = this.createReference(StreetDirectoryReference.Properties.ZONE);
    }

    public StreetDirectoryReference(String inputStreetName, String inputStreetType, String inputSuburb, String inputPostcode, String inputPage, String inputGridPosition) {
        this.zone = this.createReference(StreetDirectoryReference.Properties.ZONE);
        this.streetName = inputStreetName;
        this.streetType = inputStreetType;
        this.suburb = inputSuburb;
        this.postcode = inputPostcode;
        this.page = inputPage;
        this.gridPosition = inputGridPosition;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreetDirectoryReference other = (StreetDirectoryReference)obj;
        return StringUtils.areStringsEqualIgnoringCase(this.streetName, other.getStreetName()) && StringUtils.areStringsEqualIgnoringCase(this.streetType, other.getStreetType()) && StringUtils.areStringsEqualIgnoringCase(this.suburb, other.getSuburb()) && StringUtils.areStringsEqualIgnoringCase(this.postcode, other.getPostcode()) && StringUtils.areStringsEqualIgnoringCase(this.page, other.getPage()) && StringUtils.areStringsEqualIgnoringCase(this.gridPosition, other.getGridPosition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streetName, this.streetType, this.suburb, this.postcode, this.page, this.gridPosition);
    }

    public String[] toArray() {
        return new String[]{this.streetName, this.streetType, this.suburb, this.postcode, this.page, this.gridPosition};
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType;
    }

    public String getSuburb() {
        return this.suburb;
    }

    public void setSuburb(String suburb) {
        this.suburb = suburb;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getGridPosition() {
        return this.gridPosition;
    }

    public void setGridPosition(String gridPosition) {
        this.gridPosition = gridPosition;
    }

    public String getDirectoryReference() {
        return this.getPage() + " " + this.getGridPosition();
    }

    public DeliveryZone getZone() {
        return this.zone.get();
    }

    public void setZone(DeliveryZone zone) {
        this.zone.set(zone);
    }

    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public boolean isWarnPolicy() {
        if (SystemProperty.getInstance().isUseDeliveryZones()) {
            return this.getZone() != null && this.getZone().getPolicy() == Policy.WARN;
        }
        return false;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        if (this.label == null) {
            StringBuilder labelBuilder = new StringBuilder();
            if (this.getStreetName() != null) {
                labelBuilder.append(this.getStreetName()).append(" ");
            }
            if (this.getStreetType() != null) {
                labelBuilder.append(this.getStreetType()).append(", ");
            }
            if (this.getSuburb() != null) {
                labelBuilder.append(this.getSuburb()).append(" ");
            }
            if (this.getPostcode() != null) {
                labelBuilder.append(this.getPostcode());
            }
            this.label = labelBuilder.toString();
        }
        return this.label;
    }

    private static String findStreetDirQuery() {
        return Query.select(StreetDirectoryReference.class).equalsParam(StreetDirectoryReference.Properties.STREET_NAME).equalsParam(StreetDirectoryReference.Properties.STREET_TYPE).equalsParam(StreetDirectoryReference.Properties.SUBURB).toString();
    }

    private static String findStreetDirectoryWithZoneQuery() {
        return Query.select(StreetDirectoryReference.class).equalsParam(StreetDirectoryReference.Properties.STREET_NAME).equalsParam(StreetDirectoryReference.Properties.STREET_TYPE).equalsParam(StreetDirectoryReference.Properties.SUBURB).equalsParam(StreetDirectoryReference.Properties.POSTCODE).equalsParam(StreetDirectoryReference.Properties.ZONE).toString();
    }

    public static StreetDirectoryReference findStreetDir(String streetName, String streetType, String suburb) {
        return PersistenceManager.getObject(StreetDirectoryReference.class, StreetDirectoryReference.findStreetDirQuery(), new String[]{streetName, streetType, suburb});
    }

    public static StreetDirectoryReference findStreetDirectoryWithZone(String streetName, String streetType, String suburb, String postCode, DeliveryZone deliveryZone) {
        return PersistenceManager.getObject(StreetDirectoryReference.class, StreetDirectoryReference.findStreetDirectoryWithZoneQuery(), new String[]{streetName, streetType, suburb, postCode, deliveryZone != null ? deliveryZone.getID().toString() : ""});
    }

    public static List<StreetDirectoryReference> getAllEntries() {
        return PersistenceManager.getObjectList(StreetDirectoryReference.class, Query.select(StreetDirectoryReference.class).toString());
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<String> STREET_NAME;
        public PropertiedObject.Property<String> STREET_TYPE;
        public PropertiedObject.Property<String> SUBURB;
        public PropertiedObject.Property<String> POSTCODE;
        public PropertiedObject.Property<String> PAGE;
        public PropertiedObject.Property<String> GRID_POSITION;
        public PropertiedObject.Property<DeliveryZone> ZONE;
    }
}

