/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.departments;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.departments.Payrate;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_department")
@AccessType(value="property")
public class Department
extends PersistentObject
implements Saveable,
Displayable {
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private PersistentWriteableList<Payrate> payRates;
    private String name;
    private String extId;

    public Department() {
        this.payRates = this.createWriteableList(Department.Properties.PAYRATES);
    }

    @Column(name="label")
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @OneToMany(mappedBy="department", targetEntity=Payrate.class, fetch=FetchType.LAZY)
    public List<Payrate> getPayRates() {
        return this.payRates.getUnmodifiable();
    }

    void setPayRates(List<Payrate> payRates) {
        this.payRates = this.payRates.clone();
        this.payRates.set(payRates);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        PersistenceManager.save(this);
        for (Payrate pay : this.payRates) {
            pay.deleteChild();
        }
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public String toString() {
        return "" + this.getName();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return null;
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getName() == null ? "" : this.getName();
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Payrate> PAYRATES;
        public PropertiedObject.Property<String> EXT_ID;
    }
}

