/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.departments;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.departments.Department;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_payrate")
@AccessType(value="property")
public class Payrate
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<User> user;
    private Reference<Department> department;
    private Price payRate;

    @Deprecated
    public Payrate() {
        this.user = this.createReference(Payrate.Properties.USER);
        this.department = this.createReference(Payrate.Properties.DEPARTMENT);
    }

    public Payrate(User parentUser, Department dept) {
        this.user = this.createReference(Payrate.Properties.USER);
        this.department = this.createReference(Payrate.Properties.DEPARTMENT);
        if (this.user == null) {
            throw new IllegalStateException("Cannot create a Payrate without a user!");
        }
        if (dept == null) {
            throw new IllegalStateException("Cannot create a Payrate without a department!");
        }
        this.payRate = Price.ZERO_DOLLAR;
        this.user.set(parentUser);
        this.department.set(dept);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User value) {
        if (value == null) {
            throw new IllegalStateException("Cannot set User to null");
        }
        this.user.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_department")
    public Department getDepartment() {
        return this.department.get();
    }

    protected void setDepartment(Department value) {
        if (value == null) {
            throw new IllegalStateException("Cannot set Department to null");
        }
        this.department.set(value);
    }

    @Column(name="pay_rate")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPayRate() {
        return this.payRate;
    }

    public void setPayRate(Price thePayRate) {
        this.payRate = thePayRate;
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return false;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Department> DEPARTMENT;
        public PropertiedObject.Property PAY_RATE;
    }
}

