/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.diff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import ordermate.database.diff.VersionControlI;
import ordermate.database.diff.VersionDiff;
import ordermate.diff.BOExportMappingContainer;

public abstract class VersionControl
extends PersistentObject
implements VersionControlI,
Saveable {
    public static final Props Properties = new Props();
    private String name;
    private long currentVersion = 1L;

    @Deprecated
    public VersionControl() {
    }

    public VersionControl(String name) {
        this.name = name;
    }

    public abstract String getType();

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public List<VersionDiff> getAllVersions() {
        ObjectQuery query = Query.select(VersionDiff.class).equals(VersionDiff.Properties.VERSION_CONTROL, this);
        return PersistenceManager.getObjectList(VersionDiff.class, query.toString());
    }

    @Override
    public List<VersionDiff> getVersionDiff(long fromVersion, long toVersion) {
        ObjectQuery query = Query.select(VersionDiff.class).equals(VersionDiff.Properties.VERSION_CONTROL, this).greaterThanOrEqual(VersionDiff.Properties.VERSION_NUMBER, fromVersion);
        if (toVersion != 0L) {
            query.lessThanOrEqual(VersionDiff.Properties.VERSION_NUMBER, toVersion);
        }
        return PersistenceManager.getObjectList(VersionDiff.class, query.toString());
    }

    public void setCurrentVersion(long version) {
        this.currentVersion = version;
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public String toString() {
        return this.name == null ? "" : this.name;
    }

    public abstract BOExportMappingContainer createDiffMap();

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<Long> CURRENT_VERSION;
        public PersistentObject.DerivedProperty<String> TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)VersionControl.class), "type");
    }
}

