/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.diff;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.diff.VersionControl;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;

public class VersionDiff
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private long objectId;
    private PropertiedObject.Property changedProperty;
    private ChangeType changeType;
    private Reference<VersionControl> versionControl;
    private long versionNumber;

    @Deprecated
    public VersionDiff() {
        this.versionControl = this.createReference(VersionDiff.Properties.VERSION_CONTROL);
    }

    public VersionDiff(long objectId, PropertiedObject.Property changedProperty, ChangeType changeType, VersionControl versionControl, long versionNumber) {
        this.versionControl = this.createReference(VersionDiff.Properties.VERSION_CONTROL);
        this.objectId = objectId;
        this.changedProperty = changedProperty;
        this.changeType = changeType;
        this.versionControl.set(versionControl);
        this.versionNumber = versionNumber;
    }

    public Class<?> getClassType() {
        return this.changedProperty.getOwner();
    }

    public PropertiedObject.Property getChangedProperty() {
        return this.changedProperty;
    }

    protected void setChangedProperty(PropertiedObject.Property property) {
        this.changedProperty = property;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    protected void setChangeType(ChangeType type) {
        this.changeType = type;
    }

    public VersionControl getVersionControl() {
        return this.versionControl.get();
    }

    protected void setVersionControl(VersionControl versionControl) {
        this.versionControl.set(versionControl);
    }

    public long getVersionNumber() {
        return this.versionNumber;
    }

    protected void setVersionNumber(long version) {
        this.versionNumber = version;
    }

    public long getObjectId() {
        return this.objectId;
    }

    protected void setObjectId(long id) {
        this.objectId = id;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Transient
    public Object getChangedBO() {
        return PersistenceManager.getByID(this.getObjectId(), this.getChangedProperty().getOwner());
    }

    @Transient
    public long getExportId() {
        Object obj = this.getChangedBO();
        if (obj instanceof ExportableObject && OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
            Long masterId = ((ExportableObject)obj).getMasterId();
            if (masterId == null) {
                OrderMate.LOG.warn("Master id is NOT generated for exportable object, Class type: " + this.getClassType() + "ID: " + this.getObjectId());
                return 0L;
            }
            return masterId;
        }
        return this.getObjectId();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Long> OBJECT_ID;
        public PropertiedObject.Property<PropertiedObject.Property> CHANGED_PROPERTY;
        public PropertiedObject.Property<ChangeType> CHANGE_TYPE;
        public PropertiedObject.Property<VersionControl> VERSION_CONTROL;
        public PropertiedObject.Property<Long> VERSION_NUMBER;
        public PersistentObject.DerivedProperty<Class<?>> CLASS_TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)VersionDiff.class), "classType");
    }

    public static enum ChangeType {
        Creation,
        Update,
        Deletion;

    }
}

