/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.docket;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;

public abstract class AbstractDocket
extends PersistentObject
implements Saveable,
Displayable {
    public static final Props Properties = new Props();
    private int sequenceNumber;
    private String docketType;
    private String xml;
    private Date creationTime;
    private Reference<VirtualPrinter> originalPrinter;
    private Reference<PhysicalPrintDevice> lastPrinter;
    private String description;
    private boolean isReprint;
    private boolean previewDocket;
    private DocketClassType classType;
    private Color backgroundColor;

    protected void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public AbstractDocket() {
        this.originalPrinter = this.createReference(AbstractDocket.Properties.ORIGINAL_PRINTER);
        this.lastPrinter = this.createReference(AbstractDocket.Properties.LAST_PRINTER);
        this.isReprint = false;
        this.previewDocket = false;
    }

    public AbstractDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String theDocketType) {
        this(theOriginalPrinter, xmlPhase1, theDescription, theDocketType, 0);
    }

    public AbstractDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String theDocketType, int seqNum) {
        this.originalPrinter = this.createReference(AbstractDocket.Properties.ORIGINAL_PRINTER);
        this.lastPrinter = this.createReference(AbstractDocket.Properties.LAST_PRINTER);
        this.isReprint = false;
        this.previewDocket = false;
        this.sequenceNumber = seqNum;
        this.docketType = theDocketType;
        this.xml = xmlPhase1;
        this.description = theDescription.substring(0, theDescription.length() - 1);
        this.creationTime = new Date();
        this.originalPrinter.set(theOriginalPrinter);
    }

    public PhysicalPrintDevice getNextPrinter() {
        PhysicalPrintDevice printer = null;
        printer = this.getLastPrinter() == null ? this.getOriginalPrinter().getPrintDevice() : this.getLastPrinter().getBackupPrinter();
        this.setLastPrinter(printer);
        return printer;
    }

    public String getXMLPhase1() {
        return this.xml;
    }

    public void setLastPrinter(PhysicalPrintDevice printer) {
        this.lastPrinter.set(printer);
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = " docket for printer " + (this.getOriginalPrinter() != null ? this.getOriginalPrinter().getLabel() : "Missing printer for " + this.getID());
        }
        return this.description;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public String getDocketType() {
        return this.docketType;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public PhysicalPrintDevice getLastPrinter() {
        return this.lastPrinter.get();
    }

    public VirtualPrinter getOriginalPrinter() {
        return this.originalPrinter.get();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    public static List<AbstractDocket> getDailyDockets() {
        ArrayList<AbstractDocket> dockets = new ArrayList<AbstractDocket>();
        dockets.addAll(PersistenceManager.getObjectList(SalesAccountDocket.class, Query.select(SalesAccountDocket.class).toString()));
        dockets.addAll(PersistenceManager.getObjectList(SimpleDocket.class, Query.select(SimpleDocket.class).toString()));
        return dockets;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    protected String formatCreationTime() {
        if (this.creationTime != null) {
            DateFormat formatter = DateFormat.getTimeInstance(3);
            return formatter.format(this.creationTime);
        }
        return "";
    }

    @Override
    public String getLabel() {
        StringBuilder text = new StringBuilder("<html>");
        text.append("Printer: ");
        if (this.getOriginalPrinter() != null) {
            text.append(this.getOriginalPrinter().getLabel());
        } else {
            text.append("Missing");
        }
        text.append("<br>Docket No: ");
        text.append(this.getSequenceNumber());
        text.append("<br>Printed at ");
        text.append(this.formatCreationTime());
        text.append("</html>");
        return text.toString();
    }

    @Override
    public String getIcon() {
        return "/waitermate/images/docket.png";
    }

    public boolean isReprint() {
        return this.isReprint;
    }

    public void setReprint(boolean b) {
        this.isReprint = b;
    }

    public void setPreviewDocket(boolean previewDocket) {
        this.previewDocket = previewDocket;
    }

    public boolean isPreviewDocket() {
        return this.previewDocket;
    }

    public void setBackground(Color c) {
        this.setBackgroundColor(c);
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setBackgroundColor(Color background) {
        this.backgroundColor = background;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    public void setXml(String value) {
        this.xml = value;
    }

    public String getXml() {
        return this.xml;
    }

    public DocketClassType getClassType() {
        return this.classType;
    }

    protected void setClassType(DocketClassType value) {
        this.classType = value;
    }

    public static class DocketClassType
    extends PersistentEnumeration {
        public static final DocketClassType SALES_ACCOUNT = new DocketClassType("SALES_ACCOUNT");
        public static final DocketClassType FINANCE_TRANSACTION = new DocketClassType("FINANCE_TRANSACTION");
        public static final DocketClassType SIMPLE = new DocketClassType("SIMPLE");
        public static final Map register = DocketClassType.buildRegister(SALES_ACCOUNT, FINANCE_TRANSACTION, SIMPLE);

        private DocketClassType(String desc) {
            super(desc);
        }

        public static Map getRegister() {
            return register;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SEQUENCE_NUMBER;
        public PropertiedObject.Property DOCKET_TYPE;
        public PropertiedObject.Property XML;
        public PropertiedObject.Property<VirtualPrinter> ORIGINAL_PRINTER;
        public PropertiedObject.Property<PhysicalPrintDevice> LAST_PRINTER;
        public PropertiedObject.Property CREATION_TIME;
        public PropertiedObject.Property CLASS_TYPE;
    }
}

