/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.docket;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.Sequenced;
import ordermate.database.docket.TemplateLine;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationHelper;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.queries.docket.DocketTemplateQueries;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_docket_template")
@AccessType(value="property")
public class DocketTemplate
extends PersistentObject
implements Saveable,
TriggerActivated {
    public static final Props Properties = new Props();
    private DocketType type = DocketType.PREP_DOCKET;
    private String templateName = "New template";
    private int sequence;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
    private PersistentWriteableList<AbstractTrigger> triggers;
    private PersistentWriteableList<TemplateLine> lines;
    private String systemState;

    public DocketTemplate() {
        this(DocketType.RECEIPT);
    }

    public DocketTemplate(DocketType creationType) {
        this.triggers = (PersistentWriteableList)this.createList(DocketTemplate.Properties.TRIGGERS);
        this.lines = (PersistentWriteableList)this.createList(DocketTemplate.Properties.LINES);
        this.systemState = "ACTIVE";
        this.type = creationType;
    }

    public static List<DocketTemplate> getTemplates() {
        return PersistenceManager.getObjectList(DocketTemplate.class, DocketTemplateQueries.FIND_ALL.toString(), new Object[0]);
    }

    public static DocketTemplate findTemplate(String templateName) {
        return PersistenceManager.getObject(DocketTemplate.class, DocketTemplateQueries.FIND_BY_NAME.toString(), new Object[]{templateName});
    }

    public static DocketTemplate getHighestTemplate(DocketType templateType, TriggerActivationContext context) {
        return TriggerActivationHelper.getHighestActive(DocketTemplate.getTemplatesByType(templateType), context);
    }

    public static List<DocketTemplate> getTemplatesByType(DocketType templateType) {
        return PersistenceManager.getObjectList(DocketTemplate.class, DocketTemplateQueries.FIND_BY_TYPE.toString(), new Object[]{templateType.toString()});
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.docket.DocketTemplate$DocketType")})
    @Column(name="type")
    public DocketType getType() {
        return this.type;
    }

    @Column(name="template_name")
    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String name) {
        this.templateName = name;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy triggerActivation) {
        this.triggerActivationStrategy = triggerActivation;
    }

    @Override
    @ManyToMany
    @JoinTable(name="config_docket_template_trigger_link", joinColumns={@JoinColumn(name="FK_config_docket_template", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="FK_inventory_trigger", referencedColumnName="ID")})
    public List<AbstractTrigger> getTriggers() {
        return this.triggers.getUnmodifiable();
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger toAdd) {
        this.triggers.add(toAdd);
        return null;
    }

    public void setTriggers(List<AbstractTrigger> triggersToSet) {
        this.triggers.clear();
        Iterator<AbstractTrigger> trigIt = triggersToSet.iterator();
        while (trigIt.hasNext()) {
            this.addTrigger(trigIt.next());
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger toRemove) {
        if (!this.triggers.remove(toRemove)) {
            throw new IllegalArgumentException(toRemove + " is not linked with the docket template " + this.getTemplateName());
        }
        return true;
    }

    public void removeAllTriggers() {
        this.triggers.clear();
    }

    @OneToMany(mappedBy="template", targetEntity=TemplateLine.class)
    public List<TemplateLine> getLines() {
        return this.lines.getUnmodifiable();
    }

    public void addLine(TemplateLine toAdd) {
        this.lines.add(toAdd);
    }

    public void setLines(List<TemplateLine> linesToSet) {
        this.lines.clear();
        Iterator<TemplateLine> linesIt = linesToSet.iterator();
        while (linesIt.hasNext()) {
            this.addLine(linesIt.next());
        }
    }

    public void removeLine(TemplateLine toRemove) {
        if (!this.lines.remove(toRemove)) {
            throw new IllegalArgumentException(toRemove + " is not linked with the docket template " + this.getTemplateName());
        }
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newsequence) {
        this.sequence = newsequence;
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.triggers.saveChild();
        this.lines.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.triggers.deleteChild();
        this.lines.deleteChild();
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public String toString() {
        return this.getTemplateName();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy"), @Parameter(name="defaultValue", value="Any triggers")})
    @Column(name="trigger_activation")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    public int compareTo(Object arg0) {
        return Sequenced.SequenceComparator.getInst().compare(this, arg0);
    }

    protected void setType(DocketType newType) {
        this.type = newType;
    }

    @Column(name="system_state")
    protected String getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(String newState) {
        this.systemState = newState;
    }

    public static final class DocketType
    extends PersistentEnumeration {
        boolean isStockDocket = false;
        public static final DocketType PREP_DOCKET = new DocketType("Prep Docket");
        public static final DocketType RECEIPT = new DocketType("Receipt");
        public static final DocketType TAKINGS_DOCKET = new DocketType("Takings Docket");
        public static final DocketType TAKINGS_ALL_CASHDRAWER_DOCKET = new DocketType("All Cashdrawer Takings Docket");
        public static final DocketType LABOUR_REPORT_DOCKET = new DocketType("Labour Report Docket");
        public static final DocketType ACCOUNT_SALES_REPORT_DOCKET = new DocketType("Account Sales Report Docket");
        public static final DocketType KTS_REPORT_DOCKET = new DocketType("KTS Report Docket");
        public static final DocketType DRIVER_SUMMARY = new DocketType("Driver Summary");
        public static final DocketType VOUCHER_DOCKET = new DocketType("Voucher Docket");
        public static final DocketType COUPON_DOCKET = new DocketType("Coupon Docket");
        public static final DocketType COURSE_DOCKET = new DocketType("Course Docket");
        public static final DocketType STOCK_REQ_TEMPLATE = new DocketType("Stock Requisition Order Docket", true);
        public static final Map<String, DocketType> register = DocketType.buildRegister(PREP_DOCKET, RECEIPT, TAKINGS_DOCKET, TAKINGS_ALL_CASHDRAWER_DOCKET, LABOUR_REPORT_DOCKET, ACCOUNT_SALES_REPORT_DOCKET, KTS_REPORT_DOCKET, DRIVER_SUMMARY, COURSE_DOCKET, VOUCHER_DOCKET, STOCK_REQ_TEMPLATE, COUPON_DOCKET);

        private DocketType(String desc) {
            this(desc, false);
        }

        private DocketType(String desc, boolean isStockDocket) {
            super(desc);
            this.isStockDocket = isStockDocket;
        }

        public boolean isStockDocket() {
            return this.isStockDocket;
        }

        public static Map<String, DocketType> getRegister() {
            return Collections.unmodifiableMap(register);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TYPE;
        public PropertiedObject.Property TEMPLATE_NAME;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<AbstractTrigger> TRIGGERS;
        public PropertiedObject.Property<TemplateLine> LINES;
        public PropertiedObject.Property SYSTEM_STATE;
    }
}

