/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.docket;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.User;

public class SalesAccountDocket
extends AbstractDocket {
    public static final Props Properties = new Props();
    private String accountName;
    private Reference<Account> salesAccount;
    private KTSDocketState initialState;
    private Reference<Account> targetAccount;
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private boolean rushed;
    private int initialTime;

    protected void setSalesAccount(Reference<Account> salesAccount) {
        this.salesAccount = salesAccount;
    }

    protected void setTargetAccount(Reference<Account> targetAccount) {
        this.targetAccount = targetAccount;
    }

    protected void setUser(Reference<User> user) {
        this.user = user;
    }

    protected void setTerminal(Reference<Terminal> terminal) {
        this.terminal = terminal;
    }

    public SalesAccountDocket() {
        this.salesAccount = this.createReference(SalesAccountDocket.Properties.SALES_ACCOUNT);
        this.targetAccount = new FKReference<Account>(Account.class).collapseOnSerialize(true);
        this.user = new FKReference<User>(User.class).collapseOnSerialize(true);
        this.terminal = new FKReference<Terminal>(Terminal.class).collapseOnSerialize(true);
        this.rushed = false;
        this.initialTime = 0;
        this.setClassType(AbstractDocket.DocketClassType.SALES_ACCOUNT);
    }

    public SalesAccountDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String docketType) {
        this(theOriginalPrinter, xmlPhase1, theDescription, docketType, null, 0);
    }

    public SalesAccountDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String docketType, int sequenceNum) {
        this(theOriginalPrinter, xmlPhase1, theDescription, docketType, null, sequenceNum);
    }

    public SalesAccountDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String docketType, ItemGroup theAccount) {
        this(theOriginalPrinter, xmlPhase1, theDescription, docketType, theAccount, 0);
    }

    public SalesAccountDocket(VirtualPrinter theOriginalPrinter, String xmlPhase1, String theDescription, String docketType, ItemGroup theAccount, int seqNum) {
        super(theOriginalPrinter, xmlPhase1, theDescription, docketType, seqNum);
        this.salesAccount = this.createReference(SalesAccountDocket.Properties.SALES_ACCOUNT);
        this.targetAccount = new FKReference<Account>(Account.class).collapseOnSerialize(true);
        this.user = new FKReference<User>(User.class).collapseOnSerialize(true);
        this.terminal = new FKReference<Terminal>(Terminal.class).collapseOnSerialize(true);
        this.rushed = false;
        this.initialTime = 0;
        this.setClassType(AbstractDocket.DocketClassType.SALES_ACCOUNT);
        if (theAccount != null) {
            this.accountName = theAccount.getLabel();
            this.setSalesAccount(theAccount.getAccount());
        }
    }

    @Override
    public String getLabel() {
        StringBuilder text = new StringBuilder("<html>");
        try {
            text.append("Printer: ");
            if (this.getOriginalPrinter() != null) {
                text.append(this.getOriginalPrinter().getLabel());
            } else {
                text.append("No printer");
            }
            text.append("<br>Docket No: ").append(this.getSequenceNumber()).append("<br>Account: ").append(this.accountName).append("<br>Printed at ");
            if (this.getCreationTime() != null) {
                text.append(this.formatCreationTime());
            } else {
                text.append("No time");
            }
            text.append("</html>");
        }
        catch (Exception ex) {
            text = new StringBuilder("SalesAccountDocket : " + this.getID());
        }
        return text.toString();
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public Account getSalesAccount() {
        return this.salesAccount.get();
    }

    public void setSalesAccount(Account theAccount) {
        this.salesAccount.set(theAccount);
    }

    public String getAccountName() {
        return this.accountName;
    }

    protected void setAccountName(String value) {
        this.accountName = value;
    }

    public KTSDocketState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(KTSDocketState toSet) {
        if (toSet != null) {
            this.initialState = toSet;
        }
    }

    public boolean isRushed() {
        return this.rushed;
    }

    public void setRushed(boolean value) {
        this.rushed = value;
    }

    public void setInitialTime(int seconds) {
        this.initialTime = seconds;
    }

    public int getInitialTime() {
        return this.initialTime;
    }

    public void setTargetAccount(Account theAccount) {
        this.targetAccount.set(theAccount);
    }

    public Account getTargetAccount() {
        return this.targetAccount.get();
    }

    public User getUser() {
        return this.user.get();
    }

    public void setUser(User value) {
        this.user.set(value);
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    public void setTerminal(Terminal value) {
        this.terminal.set(value);
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends AbstractDocket.Props {
        public PropertiedObject.Property<Account> SALES_ACCOUNT;
        public PropertiedObject.Property<String> ACCOUNT_NAME;
        public PropertiedObject.Property<KTSDocketState> INITIAL_STATE;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
    }
}

