/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.failover;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.encryption.BlowfishEasy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_failover")
public class FailoverSetup
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private boolean slave;
    private boolean actingMaster = false;
    private String masterHost;
    private int masterPort;
    private int sequence;
    private Reference<Terminal> terminal;
    private SystemState systemState;
    private String failoverDate;
    private Date actualFailoverDate;

    public FailoverSetup() {
        this.terminal = this.createReference(FailoverSetup.Properties.TERMINAL);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public FailoverSetup(Terminal theTerminal) {
        this.terminal = this.createReference(FailoverSetup.Properties.TERMINAL);
        this.systemState = SystemState.ACTIVE_STATE;
        if (theTerminal == null) {
            throw new IllegalArgumentException("Cannot have a null terminal for a Failover");
        }
        if (!"ServerMate".equals(theTerminal.getTerminalType())) {
            throw new IllegalArgumentException("Cannot set a non-servermate terminal for a failover setup");
        }
        this.setTerminal(theTerminal);
        this.slave = true;
        this.actingMaster = false;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_terminal", referencedColumnName="id")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    protected void setTerminal(Terminal value) {
        this.terminal.set(value);
    }

    @Column(name="master_host")
    public String getMasterHost() {
        return this.masterHost;
    }

    public void setMasterHost(String value) {
        this.masterHost = value;
    }

    @Column(name="master_port")
    public int getMasterPort() {
        return this.masterPort;
    }

    public void setMasterPort(int value) {
        this.masterPort = value;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="is_slave")
    @Basic(optional=false)
    public boolean isSlave() {
        return this.slave;
    }

    public void setSlave(boolean value) {
        this.slave = value;
    }

    @Column(name="acting_master")
    @Basic(optional=false)
    public boolean isActingMaster() {
        return this.actingMaster;
    }

    public void setActingMaster(boolean value) {
        this.actingMaster = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @Column(name="failover_date")
    protected String getFailoverDate() {
        return this.failoverDate;
    }

    protected void setFailoverDate(String value) {
        this.failoverDate = value;
    }

    @Transient
    public Date getActualFailoverDate() {
        if (this.actualFailoverDate == null) {
            if (this.failoverDate == null) {
                return null;
            }
            BlowfishEasy bd = new BlowfishEasy("Failover");
            try {
                long millis = Long.parseLong(bd.decryptString(this.failoverDate));
                this.actualFailoverDate = new Date(millis);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error("Cannot decrypt to long ", (Throwable)ex);
            }
        }
        return this.actualFailoverDate;
    }

    protected void setActualFailoverDate(Date date) {
        this.actualFailoverDate = date;
    }

    public void startFailover() {
        BlowfishEasy bd = new BlowfishEasy("Failover");
        this.setFailoverDate(bd.encryptString(Long.toString(System.currentTimeMillis())));
        this.save();
    }

    public void endFailover() {
        this.setFailoverDate(null);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property SLAVE;
        public PropertiedObject.Property<String> MASTER_HOST;
        public PropertiedObject.Property MASTER_PORT;
        public PropertiedObject.Property ACTING_MASTER;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<String> FAILOVER_DATE;
        public PersistentObject.DerivedProperty<Date> ACTUAL_FAILOVER_DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)FailoverSetup.class), "actualFailoverDate");
    }
}

