/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.feedback;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.feedback.FeedbackAck;
import ordermate.database.feedback.FeedbackQuestion;
import org.hibernate.annotations.Type;

@Entity
@Table(name="feedback_answer")
public class FeedbackAnswer
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private int sequence;
    private String label = "";
    private String icon = "";
    private String answerText = "";
    private Reference<FeedbackAck> feedbackAck;
    private Reference<FeedbackQuestion> parentQuestion;
    private Reference<FeedbackQuestion> nextQuestion;
    private SystemState systemState;

    @Deprecated
    public FeedbackAnswer() {
        this.feedbackAck = this.createReference(FeedbackAnswer.Properties.FEEDBACK_ACK);
        this.parentQuestion = this.createReference(FeedbackAnswer.Properties.PARENT_QUESTION);
        this.nextQuestion = this.createReference(FeedbackAnswer.Properties.NEXT_QUESTION);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public FeedbackAnswer(FeedbackQuestion question) {
        this.feedbackAck = this.createReference(FeedbackAnswer.Properties.FEEDBACK_ACK);
        this.parentQuestion = this.createReference(FeedbackAnswer.Properties.PARENT_QUESTION);
        this.nextQuestion = this.createReference(FeedbackAnswer.Properties.NEXT_QUESTION);
        this.systemState = SystemState.ACTIVE_STATE;
        this.setParentQuestion(question);
        question.addAnswer(this);
        this.label = "New Answer";
        this.answerText = "Answer Text";
        this.sequence = 1;
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="icon")
    @Basic(optional=false)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    @Column(name="answer_text")
    @Basic(optional=false)
    public String getAnswerText() {
        return this.answerText;
    }

    public void setAnswerText(String value) {
        this.answerText = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_feedback_ack", referencedColumnName="id")
    public FeedbackAck getFeedbackAck() {
        return this.feedbackAck.get();
    }

    public void setFeedbackAck(FeedbackAck value) {
        this.feedbackAck.set(value);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_feedback_question", referencedColumnName="id")
    public FeedbackQuestion getParentQuestion() {
        return this.parentQuestion.get();
    }

    protected void setParentQuestion(FeedbackQuestion question) {
        this.parentQuestion.set(question);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_feedback_question_next", referencedColumnName="id")
    public FeedbackQuestion getNextQuestion() {
        return this.nextQuestion.get();
    }

    public void setNextQuestion(FeedbackQuestion question) {
        this.nextQuestion.set(question);
    }

    @Column(name="sequence")
    @Basic(optional=false)
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<String> ANSWER_TEXT;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<FeedbackAck> FEEDBACK_ACK;
        public PropertiedObject.Property<FeedbackQuestion> PARENT_QUESTION;
        public PropertiedObject.Property<FeedbackQuestion> NEXT_QUESTION;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

