/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.feedback;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.feedback.FeedbackAck;
import ordermate.database.feedback.FeedbackAnswer;
import org.hibernate.annotations.Type;

@Entity
@Table(name="feedback_question")
public class FeedbackQuestion
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    public static final int MAX_PAY_AT_TABLE_ANSWERS = 5;
    private String label = "";
    private String questionText = "";
    private Reference<FeedbackAck> defaultAck;
    private String icon;
    private SystemState systemState;
    private boolean payAtTable;
    private PersistentWriteableList<FeedbackAnswer> answers;

    public FeedbackQuestion() {
        this.defaultAck = this.createReference(FeedbackQuestion.Properties.DEFAULT_ACK);
        this.icon = "";
        this.systemState = SystemState.ACTIVE_STATE;
        this.payAtTable = true;
        this.answers = this.createWriteableList(FeedbackQuestion.Properties.ANSWERS);
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="question_text")
    @Basic(optional=false)
    public String getQuestionText() {
        return this.questionText;
    }

    public void setQuestionText(String value) {
        this.questionText = value;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="fk_feedback_ack", referencedColumnName="id")
    public FeedbackAck getDefaultAck() {
        return this.defaultAck.get();
    }

    public void setDefaultAck(FeedbackAck value) {
        this.defaultAck.set(value);
    }

    @Column(name="icon")
    @Basic(optional=true)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @OneToMany(mappedBy="parentQuestion", targetEntity=FeedbackAnswer.class)
    public List<FeedbackAnswer> getAnswers() {
        return this.answers;
    }

    public void addAnswer(FeedbackAnswer answer) {
        if (answer.getParentQuestion() != this) {
            throw new IllegalStateException("Cannot add an answer from a foreign question");
        }
        if (!this.answers.contains(answer)) {
            this.answers.add(answer);
        }
    }

    protected void setAnswers(List<FeedbackAnswer> values) {
        this.answers.set(values);
    }

    @Column(name="pay_at_table")
    public boolean isPayAtTable() {
        return this.payAtTable;
    }

    public void setPayAtTable(boolean value) {
        this.payAtTable = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.answers.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> QUESTION_TEXT;
        public PropertiedObject.Property<FeedbackAck> DEFAULT_ACK;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<FeedbackAnswer> ANSWERS;
        public PropertiedObject.Property PAY_AT_TABLE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

