/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.feedback;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.sales.Account;

@Entity
@Table(name="feedback_response")
public class FeedbackResponse
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<FeedbackQuestion> question;
    private Reference<FeedbackAnswer> answer;
    private Reference<Account> account;
    private Date responseDate;

    public FeedbackResponse() {
        this.question = this.createReference(FeedbackResponse.Properties.QUESTION);
        this.answer = this.createReference(FeedbackResponse.Properties.ANSWER);
        this.account = this.createReference(FeedbackResponse.Properties.ACCOUNT);
    }

    public FeedbackResponse(FeedbackQuestion yourQ, FeedbackAnswer yourA, Account yourAccount) {
        this.question = this.createReference(FeedbackResponse.Properties.QUESTION);
        this.answer = this.createReference(FeedbackResponse.Properties.ANSWER);
        this.account = this.createReference(FeedbackResponse.Properties.ACCOUNT);
        this.responseDate = new Date();
        this.setQuestion(yourQ);
        this.setAnswer(yourA);
        this.setAccount(yourAccount);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_feedback_question", referencedColumnName="id")
    public FeedbackQuestion getQuestion() {
        return this.question.get();
    }

    protected void setQuestion(FeedbackQuestion value) {
        this.question.set(value);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_feedback_answer", referencedColumnName="id")
    public FeedbackAnswer getAnswer() {
        return this.answer.get();
    }

    protected void setAnswer(FeedbackAnswer value) {
        this.answer.set(value);
    }

    @Column(name="response_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getResponseDate() {
        return this.responseDate;
    }

    protected void setResponseDate(Date value) {
        this.responseDate = value;
    }

    @Transient
    public Account getAccount() {
        return this.account.get();
    }

    protected void setAccount(Account value) {
        this.account.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<FeedbackQuestion> QUESTION;
        public PropertiedObject.Property<FeedbackAnswer> ANSWER;
        public PropertiedObject.Property<Date> RESPONSE_DATE;
        public PropertiedObject.Property<Account> ACCOUNT;
    }
}

