/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.misc.TradingDay;

public class AccountOptimisedDateRangeSearchFilter
extends OptimisedDateRangeSearchFilter {
    public AccountOptimisedDateRangeSearchFilter(PropertiedObject.Property prop, SQLDateType sqlDateType) {
        super(prop, sqlDateType);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        Calendar cal = Calendar.getInstance();
        DateTimeUtils.clearTimePart(cal);
        if (((Date)this.getStart()).before(cal.getTime()) && ((Date)this.getEnd()).after(cal.getTime()) || ((Date)this.getStart()).equals(cal.getTime()) || ((Date)this.getEnd()).equals(cal.getTime())) {
            query.group();
            super.addQueryRestriction(query);
            return query.or().group().isNull(this.getProperty()).wherePropertyBetween(TradingDay.Properties.DATE, (Date)this.getStart(), (Date)this.getEnd(), SQLDateType.DATE).endGroup().endGroup();
        }
        return super.addQueryRestriction(query);
    }
}

