/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.Account;
import ordermate.internationalization.Internationalization;

public class MultiOptionWithBlankOptionSearchFilter
extends MultiOptionSearchFilter {
    private final String BLANK_OPTION = Internationalization.getLiteralFor("BLANK_OPTION");

    public MultiOptionWithBlankOptionSearchFilter(PropertiedObject.Property searchProperty) {
        super(searchProperty);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        List selectes = this.getSelectedOptions();
        if (selectes.contains(this.BLANK_OPTION)) {
            query.group();
            query.isNull(Account.Properties.SOURCE);
            if (selectes.size() > 1) {
                query.or();
                ArrayList selectOptions = new ArrayList(selectes);
                selectOptions.remove(this.BLANK_OPTION);
                query.wherePropertyIn(this.getProperty(), new ArrayList(selectOptions));
            }
            query.endGroup();
            return query;
        }
        return super.addQueryRestriction(query);
    }
}

