/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.filters.optimisations.AccountOptimisation;
import ordermate.database.filters.optimisations.NoOptimisation;
import ordermate.database.filters.optimisations.OptimisationStrategy;
import ordermate.database.filters.optimisations.TradingDay6MonthsBackOptimisation;
import ordermate.database.filters.optimisations.TradingDayOptimisation;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;

public class OptimisedDateRangeSearchFilter
extends DateRangeSearchFilter {
    public OptimisedDateRangeSearchFilter(PropertiedObject.Property prop, SQLDateType sqlDateType) {
        super(prop, sqlDateType);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        Date end;
        if (!this.hasSearchValue()) {
            return query;
        }
        Date start = (Date)this.getStart();
        if (start.compareTo(end = (Date)this.getEnd()) > 0) {
            start = (Date)this.getEnd();
            end = (Date)this.getStart();
        }
        return this.getOptimisationStrategy().applyOptimisation(this.getProperty(), query, start, end, this.getDateType());
    }

    protected OptimisationStrategy getOptimisationStrategy() {
        if (this.getProperty().getOwner() == TradingDay.class) {
            return new TradingDayOptimisation();
        }
        if (this.getProperty().getOwner() == Account.class && this.getProperty().equals(Account.Properties.DATE_DUE)) {
            return new TradingDay6MonthsBackOptimisation();
        }
        if (this.getProperty().getOwner() == Account.class) {
            return new AccountOptimisation();
        }
        return new NoOptimisation();
    }
}

