/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.misc.TradingDay;

public class TradingDayDateRangeFilterAdapter
implements IRangedQuerySearchFilter<Date> {
    private IRangedQuerySearchFilter<Date> underlyingFilter;

    public TradingDayDateRangeFilterAdapter(IRangedQuerySearchFilter<Date> subjectFilter) {
        this.underlyingFilter = subjectFilter;
    }

    @Override
    public boolean hasSearchValue() {
        return this.underlyingFilter.hasSearchValue();
    }

    @Override
    public void clearSearch() {
        this.underlyingFilter.clearSearch();
    }

    @Override
    public PropertiedObject.Property getProperty() {
        return this.underlyingFilter.getProperty();
    }

    @Override
    public void setProperty(PropertiedObject.Property prop) {
        throw new UnsupportedOperationException("Cannot set property on filter adapter. Consider accessing the underlying filter instead.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.underlyingFilter.addPropertyChangeListener(listener);
    }

    @Override
    public IRangedQuerySearchFilter<Date> setStart(Date start) {
        this.underlyingFilter.setStart(start);
        return this;
    }

    @Override
    public IRangedQuerySearchFilter<Date> setEnd(Date end) {
        this.underlyingFilter.setEnd(end);
        return this;
    }

    private Date getUnderlyingStart() {
        Date start = (Date)this.underlyingFilter.getStart();
        Date end = (Date)this.underlyingFilter.getEnd();
        if (start != null && end != null && end.before(start)) {
            start = end;
        }
        return start;
    }

    private Date getUnderlyingEnd() {
        Date end = (Date)this.underlyingFilter.getEnd();
        Date start = (Date)this.underlyingFilter.getStart();
        if (end != null && start != null && start.after(end)) {
            end = start;
        }
        return end;
    }

    @Override
    public Date getStart() {
        Date start = this.getUnderlyingStart();
        if (start != null) {
            TradingDay tradingDay = TradingDay.ReportDates.getFirstTradingDayForDate(start);
            if (tradingDay != null) {
                start = tradingDay.getOpenDateTime();
            }
            if (DateTimeUtils.clearTimePart(start).after(DateTimeUtils.clearTimePart(this.getUnderlyingEnd()))) {
                start = this.getUnderlyingStart();
            }
        }
        return start;
    }

    @Override
    public Date getEnd() {
        Date end = this.getUnderlyingEnd();
        if (end != null) {
            TradingDay endDay = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).whereFunction("TIMESTAMP(finance_trading_day.close_day, finance_trading_day.close_time) = '" + DateTimeUtils.getSQLTimestampFormat().format(end) + "'").toString());
            if (endDay != null) {
                return end;
            }
            TradingDay day = TradingDay.ReportDates.getLastTradingDayForDate(end);
            if (day != null) {
                end = day.getCloseDateTime();
            }
            if (end == null) {
                end = new Date();
            }
            if (DateTimeUtils.clearTimePart(end).before(DateTimeUtils.clearTimePart(this.getUnderlyingStart()))) {
                end = this.getUnderlyingEnd();
            }
        }
        return end;
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.hasSearchValue()) {
            return query;
        }
        Date existingStart = (Date)this.underlyingFilter.getStart();
        Date existingEnd = (Date)this.underlyingFilter.getEnd();
        Calendar end = DateTimeUtils.toCal(this.getEnd());
        Date now = new Date();
        if (!DateTimeUtils.clearMillis(now).equals(DateTimeUtils.clearMillis(end.getTime()))) {
            end.add(13, -1);
        }
        this.underlyingFilter.setStart(this.getStart());
        this.underlyingFilter.setEnd(end.getTime());
        ObjectQuery returnedQuery = this.underlyingFilter.addQueryRestriction(query);
        this.underlyingFilter.setStart(existingStart);
        this.underlyingFilter.setEnd(existingEnd);
        return returnedQuery;
    }

    public IRangedQuerySearchFilter<Date> getUnderlyingFilter() {
        return this.underlyingFilter;
    }

    public void setUnderlyingFilter(IRangedQuerySearchFilter<Date> dateRangeFilter) {
        this.underlyingFilter = dateRangeFilter;
    }
}

