/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters.optimisations;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.filters.optimisations.OptimisationStrategy;
import ordermate.database.misc.TradingDay;

public class DateDueOptimization
implements OptimisationStrategy {
    private static final int MONTH = -1;

    private Date getStartDate(Date start) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    @Override
    public ObjectQuery applyOptimisation(PropertiedObject.Property property, ObjectQuery query, Date start, Date end, SQLDateType dateType) {
        return query.group().wherePropertyBetween(TradingDay.Properties.DATE, this.getStartDate(start), end, SQLDateType.DATE).endGroup().group().wherePropertyBetween(property, start, end, dateType).endGroup();
    }
}

