/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.filters.optimisations;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import ordermate.database.filters.optimisations.OptimisationStrategy;

public class TradingDayOptimisation
implements OptimisationStrategy {
    @Override
    public ObjectQuery applyOptimisation(PropertiedObject.Property property, ObjectQuery query, Date start, Date end, SQLDateType dateType) {
        String startDateSQLString = DateTimeUtils.getSQLTimestampFormat().format(start);
        String endDateSQLString = DateTimeUtils.getSQLTimestampFormat().format(end);
        return query.wherePropertyBetween(property, start, end, SQLDateType.DATE).whereFunction("TIMESTAMP(finance_trading_day.day, finance_trading_day.time) BETWEEN '" + startDateSQLString + "' AND '" + endDateSQLString + "'");
    }
}

