/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.PayableHelper;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.internationalization.Internationalization;

public class AccountPercentagePayable
implements Payable,
PriceAdjustable {
    private ItemGroup itemGroup;
    private Price total;
    private List<FinanceTransaction> financeTransactions;
    private int paymentPartNumber;
    private double percentage;

    public AccountPercentagePayable(ItemGroup theGroup, double percentageAmount, Price amountToPay, int customerNumber, boolean lastPayment) {
        this.itemGroup = theGroup;
        this.percentage = percentageAmount;
        this.total = lastPayment ? this.itemGroup.getDue() : amountToPay;
        this.financeTransactions = new ArrayList<FinanceTransaction>();
        this.paymentPartNumber = customerNumber;
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction transaction) {
        this.itemGroup.addFinanceTransaction(transaction);
        this.financeTransactions.add(transaction);
        if (transaction.isActive()) {
            this.total = this.total.add(transaction.getSurcharge());
        }
    }

    @Override
    public void removeFinanceTransaction(FinanceTransaction transaction) {
        this.itemGroup.removeFinanceTransaction(transaction);
        this.financeTransactions.remove(transaction);
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return this.itemGroup.allowsPayingIntoCredit();
    }

    @Override
    public Price getDue() {
        return this.getDue(0.01);
    }

    @Override
    public Price getDue(double roundAmt) {
        return new Price(this.total.doubleValue() - this.getPaid().doubleValue(), roundAmt);
    }

    @Override
    public String getLabel() {
        return Internationalization.getLiteralFor("COVER") + " " + this.paymentPartNumber + ": " + MathsUtils.roundDoubleToDecPlaces(this.percentage * 100.0, 2) + "%";
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    @Override
    public List<FinanceTransaction> getFinanceTransactions() {
        return this.financeTransactions;
    }

    @Override
    public Price getPaid() {
        double paid = 0.0;
        for (FinanceTransaction txn : this.getFinanceTransactions()) {
            if (!txn.isActive()) continue;
            paid += txn.getPaid().doubleValue() + txn.getRoundingAmt().negate().doubleValue();
        }
        return new Price(paid, 0.01);
    }

    @Override
    public Payable.PaidState getPaidState() {
        double due = this.getDue().doubleValue();
        if (due != 0.0 && due >= -Price.EQUIVALENT_THRESHOLD && due <= Price.EQUIVALENT_THRESHOLD) {
            return UNPAYABLE_BY_ROUNDING;
        }
        if (due > 0.0) {
            return NOT_PAID;
        }
        if (this.getTotal().equals(new Price(0.0))) {
            return UNPAYABLE;
        }
        return PAID;
    }

    @Override
    public Price getTendered() {
        Price tendered = new Price(0.0);
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        for (FinanceTransaction payment : payments) {
            tendered = new Price(tendered.doubleValue() + payment.getTendered().doubleValue(), Price.DEFAULT_ROUND_AMOUNT);
        }
        return tendered;
    }

    @Override
    public Price getTotal() {
        return this.total;
    }

    @Override
    public void pay() {
        this.itemGroup.pay();
    }

    @Override
    public void delete() {
        this.itemGroup.delete();
    }

    @Override
    public boolean hasChanged() {
        return this.itemGroup.hasChanged();
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.itemGroup.prepareForSave(context);
    }

    @Override
    public void save() {
        this.itemGroup.save();
    }

    @Override
    public Color getBackgroundColor() {
        return this.itemGroup.getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        return this.itemGroup.getForegroundColor();
    }

    @Override
    public String getIcon() {
        return this.itemGroup.getIcon();
    }

    @Override
    public boolean isPaidModifiable() {
        return !SystemProperty.getInstance().isSinglePaymentMode();
    }

    @Override
    public Long getID() {
        return this.itemGroup.getID();
    }

    public Class getObjectType() {
        return this.itemGroup.getObjectType();
    }

    @Override
    public boolean isPersistent() {
        return this.itemGroup.isPersistent();
    }

    @Override
    public List<FinanceTransactionDocket> getEftposDockets() {
        return PayableHelper.getEftposDockets(this.financeTransactions);
    }

    @Override
    public boolean hasEftposDockets() {
        return PayableHelper.hasEftposDockets(this.financeTransactions);
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        this.itemGroup.addSalesPriceAdjustment(adjustment, context);
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        return this.itemGroup.removePriceAdjustment(adjustment, context);
    }

    @Override
    public boolean hasPriceAdjustment(InventoryPriceAdjustment adjustment) {
        return this.itemGroup.hasPriceAdjustment(adjustment);
    }

    @Override
    public SalesPriceAdjustment getPriceAdjustment(InventoryPriceAdjustment adjustment) {
        return this.itemGroup.getPriceAdjustment(adjustment);
    }

    @Override
    public boolean isDiscounted() {
        return this.itemGroup.isDiscounted();
    }
}

