/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.database.DBConnectionInterface;
import ordermate.database.DatabaseService;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;

public class CashDrawerTakingsSummaryCreator {
    private final DatabaseService service;

    public CashDrawerTakingsSummaryCreator(DatabaseService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawerTakingsSummary createSummary(CashDrawer cashdrawer, Shift shift, DBConnectionInterface dc) {
        CashDrawerTakingsSummary summary = new CashDrawerTakingsSummary();
        try {
            Object[] params = new Object[]{cashdrawer.getID(), shift.getID()};
            ResultSet rs = dc.executeQuery(this.getGetCashDrawerSummaryPS().toString(), params);
            try {
                while (rs.next()) {
                    long unitID = rs.getLong("unit_id");
                    double amount = rs.getDouble("total");
                    FinanceUnit unit = PersistenceManager.getByID(unitID, FinanceUnit.class);
                    summary.setUnitTakings(unit, amount);
                }
            }
            finally {
                dc.release(rs);
            }
            summary.setTips(this.service.getSumQueryResult(this.getGetCashDrawerTipsPS(), params, "total"));
            summary.setTotalCashOut(this.service.getSumQueryResult(this.getGetTotalCashoutPS(cashdrawer, shift), null, "total"));
            summary.setCashTips(this.service.getSumQueryResult(this.getGetCashDrawerCashTipsPS(), params, "total"));
            summary.setTotalCardTips(this.service.getSumQueryResult(this.getGetCashDrawerCardTipsPS(), params, "total"));
            summary.setTotalWebTips(this.service.getSumQueryResult(this.getCashDrawerWebTipsPS(), params, "total"));
            for (FinanceUnit unit : FinanceUnit.getCardPayableUnits()) {
                summary.setTipForSubtype(unit, new Price(this.service.getSumQueryResult(this.getCashDrawerTipsForUnit(unit), params, "total"), 0.01));
            }
            for (FinanceUnit unit : FinanceUnit.getWebUnits()) {
                summary.setTipForSubtype(unit, new Price(this.service.getSumQueryResult(this.getCashDrawerTipsForUnit(unit), params, "total"), 0.01));
            }
        }
        catch (SQLException e) {
            this.service.handleSQLError(e);
        }
        return summary;
    }

    private ObjectQuery getGetCashDrawerSummaryPS() {
        return new ObjectQuerySQLAdapter("SELECT finance_unit.ID as unit_id, finance_unit.Name as unit_name, finance_unit.unit_type as unit_type, finance_unit.skimmable as skimmable, finance_transaction.FK_config_cashdrawer AS cashdrawer_id, SUM(finance_transaction.amount_paid) AS total FROM finance_transaction, finance_unit WHERE finance_unit.system_state = 'ACTIVE' AND finance_unit.unit_type <> 'PETTY_CASH' AND finance_unit.unit_type <> 'OVER_CHARGE' AND finance_transaction.FK_finance_unit = finance_unit.ID AND finance_transaction.system_state <> 'DELETED' AND finance_transaction.FK_finance_transaction IS NULL AND finance_transaction.FK_config_cashdrawer = ? AND finance_transaction.FK_finance_shift = ? GROUP BY unit_id");
    }

    private ObjectQuery getGetCashDrawerTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_config_cashdrawer = ? AND FK_finance_shift = ? AND system_state = 'ACTIVE'");
    }

    private ObjectQuery getGetTotalCashoutPS(CashDrawer drawer, Shift shift) {
        return Query.sum(FinanceTransaction.Properties.CASH_OUT, "total").active(FinanceTransaction.class).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer).equals(FinanceTransaction.Properties.SHIFT, shift);
    }

    private ObjectQuery getGetCashDrawerCashTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_config_cashdrawer = ? AND FK_finance_shift = ? AND system_state = 'ACTIVE'AND type = 'CASH'");
    }

    private ObjectQuery getGetCashDrawerCardTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_config_cashdrawer = ? AND FK_finance_shift = ? AND system_state = 'ACTIVE' AND (type = 'DEBIT' OR type = 'CREDIT') ");
    }

    private ObjectQuery getCashDrawerWebTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_config_cashdrawer = ? AND FK_finance_shift = ? AND system_state = 'ACTIVE' AND type = 'WEB' ");
    }

    private ObjectQuery getCashDrawerTipsForUnit(FinanceUnit unit) {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS 'total' FROM finance_transaction WHERE finance_transaction.fk_config_cashdrawer =  ? AND finance_transaction.fk_finance_shift = ? AND finance_transaction.system_state = 'ACTIVE' AND fk_finance_unit = " + unit.getID());
    }
}

