/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ordermate.database.finance.Denomination;

public class ChangeCalculator {
    private List<Denomination> denominations;

    public ChangeCalculator(Denomination[] denom) {
        this.denominations = new ArrayList<Denomination>(Arrays.asList(denom));
        Collections.sort(this.denominations, new PropertyComparator((PropertiedObject.Property<? extends Comparable>)Denomination.Properties.VALUE).negate());
    }

    public List<Denomination> calculateChange(Price cashGiven, Price total) {
        ArrayList<Denomination> change = new ArrayList<Denomination>();
        if (cashGiven == null || total == null || cashGiven.approximatelyEquals(total) || cashGiven.lessThan(total) || cashGiven.lessThan(Price.ZERO_DOLLAR) || total.lessThan(Price.ZERO_DOLLAR)) {
            return change;
        }
        Price runningTotal = cashGiven.subtract(total);
        for (Denomination denom : this.denominations) {
            Price denomPrice = new Price(denom.getValue(), 0.01);
            while (runningTotal.equals(denomPrice) || runningTotal.greaterThan(denomPrice)) {
                change.add(denom);
                runningTotal = runningTotal.subtract(new Price(denom.getValue(), 0.01));
            }
        }
        return change;
    }
}

