/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.finance.FilterItemGroup;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.CustomerSeatLink;

public class CustomerPerSeatItemGroup
extends FilterItemGroup {
    private Customer customer;
    private List<CustomerSeatLink> customerSeatLinks = new ArrayList<CustomerSeatLink>();

    public CustomerPerSeatItemGroup(TableAccount newFilterGroup, Customer theCustomer, int[] customerSeats) {
        super("CUSTOMER PER SEAT", newFilterGroup);
        this.initializeSellables(this.getAllCustomerLinks(newFilterGroup, theCustomer, customerSeats));
        this.setCustomer(theCustomer, newFilterGroup.getEventContext());
    }

    private List<Sellable> getAllCustomerLinks(TableAccount acc, Customer theCustomer, int[] seatsForCustomer) {
        ArrayList<Sellable> allCustomerSeatSellables = new ArrayList<Sellable>();
        for (int seat : seatsForCustomer) {
            allCustomerSeatSellables.addAll(acc.getSellablesForSeat(seat));
            this.addCustomerSeatLink(new CustomerSeatLink(seat, theCustomer, acc));
        }
        return allCustomerSeatSellables;
    }

    public void addCustomerSeatLink(CustomerSeatLink seatLink) {
        this.customerSeatLinks.add(seatLink);
    }

    public List<CustomerSeatLink> getCustomerSeatLinks() {
        return this.customerSeatLinks;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerPerSeatItemGroup)) {
            return false;
        }
        CustomerPerSeatItemGroup other = (CustomerPerSeatItemGroup)obj;
        if (this.parentAccount.equals(other.parentAccount) && this.customer.equals(other.getCustomer())) {
            for (SalesLineItem item : other.getItems()) {
                if (this.items.contains(item)) continue;
                return false;
            }
            for (CustomerSeatLink cSeatLink : other.getCustomerSeatLinks()) {
                if (this.customerSeatLinks.contains(cSeatLink)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Price getTotal() {
        this.checkNoDollarPriceAdjustment(this.parentAccount);
        return this.getFinalPriceAdjustments(this.getSummaryTotal().toBigDecimal().doubleValue());
    }

    private Price getFinalPriceAdjustments(double premiumTotal) {
        double total = premiumTotal;
        HashSet<SalesPriceAdjustment> finalAdjustments = new HashSet<SalesPriceAdjustment>();
        for (FinalPriceInvAdjustment invAdj : PriceAdjustmentManager.getInstance().getFinalPriceAdjustments()) {
            FinalSalesPriceAdjustment salesAdjustment = (FinalSalesPriceAdjustment)this.getPriceAdjHelper().getPriceAdjustment(invAdj);
            if (salesAdjustment == null) continue;
            for (SalesPriceAdjustment adj : this.getPriceAdjustments()) {
                if (!salesAdjustment.getInventoryPriceAdjustment().equals(adj.getInventoryPriceAdjustment())) continue;
                finalAdjustments.add(adj);
            }
        }
        if (!finalAdjustments.isEmpty()) {
            return new Price(this.calculateSurcharges(total, finalAdjustments), 0.01).add(this.getTotalRoundingAmt());
        }
        return new Price(total, 0.01).add(this.getTotalRoundingAmt());
    }

    private double calculateSurcharges(double totalCurrent, Set<SalesPriceAdjustment> finalAdjustments) {
        double total = totalCurrent;
        double mySurchargeTotal = 0.0;
        for (FinanceTransaction txn : this.financeTransactions) {
            mySurchargeTotal += txn.getSurcharge().doubleValue();
        }
        double totalAppliedToMyItems = 0.0;
        for (SalesLineItem lineItems : this.items) {
            for (SalesItem item : lineItems.getSalesItems()) {
                for (SalesComponent comp : item.getComponentList()) {
                    for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
                        if (!finalAdjustments.contains(usage.getSalesPriceAdjustment())) continue;
                        totalAppliedToMyItems += usage.getValue().doubleValue();
                    }
                }
            }
        }
        return total + totalAppliedToMyItems + mySurchargeTotal;
    }

    @Override
    public boolean allowsAdvancedPriceAdjustments() {
        return true;
    }

    @Override
    public void close(EventContext context) {
        throw new UnsupportedOperationException("CustomerPerSeatItemGroup does not allow partial closing.");
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public boolean hasCustomer() {
        return this.customer != null;
    }

    @Override
    public List<SalesLineItem> setCustomer(Customer customer, EventContext context) {
        this.customer = customer;
        for (SalesLineItem anItem : this.items) {
            anItem.setCustomer(customer);
        }
        return this.items;
    }

    @Override
    public boolean usesSeatNums() {
        return true;
    }

    @Override
    public int getNumPatrons() {
        if (this.customerSeatLinks.isEmpty()) {
            return 1;
        }
        return this.customerSeatLinks.size();
    }

    @Override
    public boolean hasChanged() {
        return this.parentAccount.hasChanged();
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return this.parentAccount.allowsPayingIntoCredit();
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        boolean removed = false;
        for (SalesLineItem nextItem : this.items) {
            removed = removed || nextItem.removePriceAdjustment(adjustment, context);
        }
        return this.adjustments.remove(adjustment);
    }

    @Override
    public int getOrderNumber() {
        return this.parentAccount.getOrderNumber();
    }

    @Override
    public void updateCustomerReference() {
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        adjustment.setCustomer(this.customer);
        super.addSalesPriceAdjustment(adjustment, context);
        this.getPriceAdjHelper().calcSalesPriceAdjustmentUsages();
    }
}

