/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.PayableHelper;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class DebtorTransactionGroupAdapter
extends ItemGroup {
    public static final String TYPE = "DEBTOR_TRANSACTION";
    private AbstractDebtor debtor;
    private List<FinanceTransaction> financeTransactions;
    private List<FinanceTransaction> unsavedTransactions = new ArrayList<FinanceTransaction>();
    private Price amountDue = new Price(0.0, 0.01);

    public DebtorTransactionGroupAdapter(DebtorPaymentAgent theAgent) {
        this(theAgent.getDebtor(), theAgent.getFinanceTransactions(), theAgent.getDebtor().getAmountOutstanding());
    }

    public DebtorTransactionGroupAdapter(AbstractDebtor theDebtor, List<FinanceTransaction> newFinanceTransactions, Price newAmountDue) {
        this.debtor = theDebtor;
        this.financeTransactions = new ArrayList<FinanceTransaction>(newFinanceTransactions);
        this.amountDue = new Price(newAmountDue, 0.05);
    }

    @Override
    public Account getAccount() {
        return null;
    }

    @Override
    public List<SalesLineItem> getItems() {
        return Collections.emptyList();
    }

    @Override
    public List<SalesLineItem> getActiveItemsModifiable() {
        return this.getItems();
    }

    @Override
    public List getAllItemsModifiable() {
        return this.getItems();
    }

    @Override
    public List<GiftVoucherTransaction> getVoucherTxns() {
        return Collections.emptyList();
    }

    @Override
    public Price getTotal() {
        Price total = new Price(0.0, 0.01);
        if (this.financeTransactions != null && this.financeTransactions.size() > 0) {
            for (FinanceTransaction trans : this.financeTransactions) {
                total = total.add(trans.getPaid());
            }
        }
        return total;
    }

    @Override
    public Price getTax() {
        return Price.ZERO_DOLLAR;
    }

    @Override
    public Price getDue() {
        return this.amountDue;
    }

    @Override
    public Customer getCustomer() {
        if (this.debtor.hasCustomer()) {
            return ((CustomerDebtorInterface)((Object)this.debtor)).getCustomer();
        }
        return null;
    }

    @Override
    public int getOrderNumber() {
        return this.debtor.getID().intValue();
    }

    @Override
    public Long getID() {
        return this.debtor.getID();
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction toAdd, List<SalesLineItem> items) {
        this.addFinanceTransaction(toAdd);
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction toAdd) {
        if (!toAdd.isPersistent()) {
            this.unsavedTransactions.add(toAdd);
        }
        this.financeTransactions.add(toAdd);
    }

    @Override
    public List<FinanceTransaction> getFinanceTransactions() {
        return this.financeTransactions;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getLabel() {
        return this.debtor.getLabel();
    }

    @Override
    public List getAllItems() {
        return new ArrayList(0);
    }

    @Override
    public void close(EventContext context) {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void removeFinanceTransaction(FinanceTransaction toRemove) {
    }

    @Override
    public List setCustomer(Customer customer, EventContext context) {
        return null;
    }

    @Override
    public User getUser() {
        return null;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean isLocked(User byUser) {
        return false;
    }

    @Override
    public boolean lock(User lockUser) {
        return false;
    }

    @Override
    public boolean relock(User lockUser) {
        return false;
    }

    @Override
    public void unlock() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        for (FinanceTransaction txn : this.unsavedTransactions) {
            txn.saveChild();
        }
        this.unsavedTransactions.clear();
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return false;
    }

    @Override
    public List<SalesPriceAdjustment> getPriceAdjustments() {
        return Collections.emptyList();
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        return false;
    }

    @Override
    public boolean removeAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        return false;
    }

    public SalesPriceAdjustment addPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        return null;
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
    }

    @Override
    public void addOrderedItem(SalesLineItem item) {
    }

    @Override
    public boolean isAccount() {
        return false;
    }

    @Override
    public List<FinanceTransactionDocket> getEftposDockets() {
        List<FinanceTransactionDocket> dockets = PayableHelper.getEftposDockets(this.financeTransactions);
        dockets.addAll(PayableHelper.getEftposDockets(this.unsavedTransactions));
        return dockets;
    }

    @Override
    public boolean hasEftposDockets() {
        return PayableHelper.hasEftposDockets(this.financeTransactions) || PayableHelper.hasEftposDockets(this.unsavedTransactions);
    }
}

