/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="finance_denomination")
@AccessType(value="property")
public class Denomination
extends PersistentDisplayableObject {
    private static Denomination FIVE_CENTS;
    private static Denomination TEN_CENTS;
    private static Denomination TWENTY_CENTS;
    private static Denomination FIFTY_CENTS;
    private static Denomination ONE_DOLLAR;
    private static Denomination TWO_DOLLARS;
    private static Denomination FIVE_DOLLARS;
    private static Denomination TEN_DOLLARS;
    private static Denomination TWENTY_DOLLARS;
    private static Denomination FIFTY_DOLLARS;
    private static Denomination ONE_HUNDRED_DOLLARS;
    private static Denomination[] denominations;
    public static final Props Properties;
    private double value;

    public static final Denomination[] getDenominations() {
        if (denominations == null) {
            denominations = new Denomination[]{Denomination.getOneHundredDollars(), Denomination.getFiftyDollars(), Denomination.getTwentyDollars(), Denomination.getTenDollars(), Denomination.getFiveDollars(), Denomination.getTwoDollars(), Denomination.getOneDollar(), Denomination.getFiftyCents(), Denomination.getTwentyCents(), Denomination.getTenCents(), Denomination.getFiveCents()};
        }
        Denomination[] copy = new Denomination[denominations.length];
        System.arraycopy(denominations, 0, copy, 0, denominations.length);
        return copy;
    }

    @Column(name="value")
    public double getValue() {
        return this.value;
    }

    @Override
    @Transient
    public String getLabel() {
        return new Price(this.value, 0.01).toString();
    }

    private static final Denomination get(double value) {
        String sql = Query.select(Denomination.class).equalsParam(Denomination.Properties.VALUE).toString();
        return PersistenceManager.getObject(Denomination.class, sql, new Object[]{new Double(value)});
    }

    public static Denomination getFiveCents() {
        if (FIVE_CENTS == null) {
            FIVE_CENTS = Denomination.get(0.05);
        }
        return FIVE_CENTS;
    }

    public static Denomination getTenCents() {
        if (TEN_CENTS == null) {
            TEN_CENTS = Denomination.get(0.1);
        }
        return TEN_CENTS;
    }

    public static Denomination getTwentyCents() {
        if (TWENTY_CENTS == null) {
            TWENTY_CENTS = Denomination.get(0.2);
        }
        return TWENTY_CENTS;
    }

    public static Denomination getFiftyCents() {
        if (FIFTY_CENTS == null) {
            FIFTY_CENTS = Denomination.get(0.5);
        }
        return FIFTY_CENTS;
    }

    public static Denomination getOneDollar() {
        if (ONE_DOLLAR == null) {
            ONE_DOLLAR = Denomination.get(1.0);
        }
        return ONE_DOLLAR;
    }

    public static Denomination getTwoDollars() {
        if (TWO_DOLLARS == null) {
            TWO_DOLLARS = Denomination.get(2.0);
        }
        return TWO_DOLLARS;
    }

    public static Denomination getFiveDollars() {
        if (FIVE_DOLLARS == null) {
            FIVE_DOLLARS = Denomination.get(5.0);
        }
        return FIVE_DOLLARS;
    }

    public static Denomination getTenDollars() {
        if (TEN_DOLLARS == null) {
            TEN_DOLLARS = Denomination.get(10.0);
        }
        return TEN_DOLLARS;
    }

    public static Denomination getTwentyDollars() {
        if (TWENTY_DOLLARS == null) {
            TWENTY_DOLLARS = Denomination.get(20.0);
        }
        return TWENTY_DOLLARS;
    }

    public static Denomination getFiftyDollars() {
        if (FIFTY_DOLLARS == null) {
            FIFTY_DOLLARS = Denomination.get(50.0);
        }
        return FIFTY_DOLLARS;
    }

    public static Denomination getOneHundredDollars() {
        if (ONE_HUNDRED_DOLLARS == null) {
            ONE_HUNDRED_DOLLARS = Denomination.get(100.0);
        }
        return ONE_HUNDRED_DOLLARS;
    }

    protected void setValue(double value) {
        this.value = value;
    }

    static {
        Properties = new Props();
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property VALUE;
    }
}

