/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.PayableHelper;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.users.User;

public abstract class FilterItemGroup
extends ItemGroup {
    private final String groupType;
    protected List<SalesLineItem> items;
    protected List<GiftVoucherTransaction> voucherTransactions;
    protected Account parentAccount;
    protected List<FinanceTransaction> financeTransactions;
    protected List<SalesPriceAdjustment> adjustments;

    public FilterItemGroup(String type, Account newFilterGroup) {
        super(newFilterGroup.intID());
        this.groupType = type;
        this.checkNoDollarPriceAdjustment(newFilterGroup);
        this.parentAccount = newFilterGroup;
        this.financeTransactions = new ArrayList<FinanceTransaction>();
        this.adjustments = new ArrayList<SalesPriceAdjustment>();
    }

    protected void initializeSellables(List<Sellable> filterItems) {
        SellableWrapperFactory factory = new SellableWrapperFactory();
        this.items = factory.getSellingObjectsAs(filterItems, SalesLineItem.class);
        this.voucherTransactions = factory.getSellingObjectsAs(filterItems, GiftVoucherTransaction.class);
    }

    protected void checkNoDollarPriceAdjustment(ItemGroup newFilterGroup) {
        List<SalesPriceAdjustment> groupAdjustments = PriceAdjustmentManager.getInstance().getMatching(newFilterGroup.getPriceAdjHelper().getDiscounts(), PriceAdjustmentUnit.DOLLAR_UNIT);
        if (!groupAdjustments.isEmpty() && !SystemProperty.getInstance().isCustomerAssignmentPerSeat()) {
            throw new IllegalArgumentException("FilterItemGroup cannot wrap ItemGroups with discounts and surcharges");
        }
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract Price getTotal();

    @Override
    public abstract boolean allowsAdvancedPriceAdjustments();

    @Override
    public abstract void close(EventContext var1);

    @Override
    public abstract Customer getCustomer();

    @Override
    public abstract boolean hasCustomer();

    @Override
    public abstract List setCustomer(Customer var1, EventContext var2);

    @Override
    public abstract boolean usesSeatNums();

    @Override
    public abstract int getNumPatrons();

    @Override
    public abstract boolean hasChanged();

    @Override
    public abstract boolean allowsPayingIntoCredit();

    @Override
    public abstract boolean removePriceAdjustment(SalesPriceAdjustment var1, EventContext var2);

    @Override
    public abstract int getOrderNumber();

    @Override
    public abstract void updateCustomerReference();

    @Override
    public Account getAccount() {
        return this.parentAccount.getAccount();
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.parentAccount.prepareForSave(context);
    }

    @Override
    public void save() {
        this.parentAccount.save();
    }

    @Override
    public List<SalesLineItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public List<SalesLineItem> getActiveItemsModifiable() {
        return this.items;
    }

    @Override
    public List getAllItems() {
        return this.getItems();
    }

    @Override
    public List getAllItemsModifiable() {
        return this.items;
    }

    @Override
    public List<GiftVoucherTransaction> getVoucherTxns() {
        return Collections.unmodifiableList(this.voucherTransactions);
    }

    @Override
    public List<FinanceTransaction> getFinanceTransactions() {
        return this.financeTransactions;
    }

    @Override
    public Color getBackgroundColor() {
        return this.parentAccount.getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        return this.parentAccount.getForegroundColor();
    }

    @Override
    public String getIcon() {
        return this.parentAccount.getIcon();
    }

    @Override
    public Long getID() {
        return this.parentAccount.getID();
    }

    @Override
    public String getLabel() {
        return this.parentAccount.getLabel();
    }

    @Override
    public String getType() {
        return this.groupType;
    }

    @Override
    public User getUser() {
        return this.parentAccount.getUser();
    }

    @Override
    public int hashCode() {
        return this.parentAccount.hashCode();
    }

    @Override
    public boolean isLocked() {
        return this.parentAccount.isLocked();
    }

    @Override
    public boolean isLocked(User byUser) {
        return this.parentAccount.isLocked(byUser);
    }

    @Override
    public boolean isOpen() {
        return this.parentAccount.isOpen();
    }

    @Override
    public boolean lock(User user) {
        return this.parentAccount.lock(user);
    }

    @Override
    public boolean relock(User user) {
        return this.parentAccount.relock(user);
    }

    public void setBackgroundColor(Color newColor) {
        throw new UnsupportedOperationException("FilterItemGroup does not allow set background colour");
    }

    public void setForegroundColor(Color newColor) {
        throw new UnsupportedOperationException("FilterItemGroup does not allow set foreground colour");
    }

    public void setIcon(String newIcon) {
        throw new UnsupportedOperationException("FilterItemGroup does not allow set icon");
    }

    @Override
    public String toString() {
        return this.parentAccount.toString();
    }

    @Override
    public void unlock() {
        this.parentAccount.unlock();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Item groups cannot be deleted.");
    }

    @Override
    public List<SalesPriceAdjustment> getPriceAdjustments() {
        return Collections.unmodifiableList(this.adjustments);
    }

    @Override
    public boolean isAccount() {
        return false;
    }

    @Override
    public List<FinanceTransactionDocket> getEftposDockets() {
        return PayableHelper.getEftposDockets(this.financeTransactions);
    }

    @Override
    public boolean hasEftposDockets() {
        return PayableHelper.hasEftposDockets(this.financeTransactions);
    }

    @Override
    public void removeFinanceTransaction(FinanceTransaction toRemove) {
        this.parentAccount.removeFinanceTransaction(toRemove);
        for (GiftVoucherTransaction txn : this.voucherTransactions) {
            txn.removeFinancePayments(toRemove);
        }
        this.financeTransactions.remove(toRemove);
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction toAdd, List<SalesLineItem> transItems) {
        this.parentAccount.addFinanceTransaction(toAdd, transItems);
        for (GiftVoucherTransaction txn : this.voucherTransactions) {
            txn.addFinancePayments(toAdd);
        }
        this.financeTransactions.add(toAdd);
    }

    public List<Sellable> getAllSellableItems() {
        SellableWrapperFactory factory = new SellableWrapperFactory();
        return Collections.unmodifiableList(factory.getSellables(this.items, this.voucherTransactions));
    }

    @Override
    protected boolean removeAdjustment(SalesPriceAdjustment adjToRemove, EventContext context) {
        return this.removePriceAdjustment(adjToRemove, context);
    }

    @Override
    public void addOrderedItem(SalesLineItem item) {
        this.items.add(item);
        this.parentAccount.getItemHelper().addItem(item);
    }

    @Override
    public void addSalesPriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        this.adjustments.add(adjustment);
        TerminalEventLog.logAddAdjustment(context, adjustment, this);
        this.parentAccount.addSalesPriceAdjustment(adjustment, context);
    }
}

