/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.integration.accounting.GLAccountCode;
import ordermate.database.integration.accounting.settings.GLAccount;
import org.apache.commons.lang.NotImplementedException;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="finance_accounting_group")
@AccessType(value="property")
public class FinanceAccountingGroup
extends PersistentDisplayableObject
implements GLAccountCode,
Saveable {
    public static final Props Properties = new Props();
    private String memo;
    private Reference<GLAccount> glCode;

    public FinanceAccountingGroup() {
        this.glCode = this.createReference(FinanceAccountingGroup.Properties.GL_CODE);
    }

    @Column(name="memo")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String newMemo) {
        this.memo = newMemo;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_acc_gl_account")
    public GLAccount getGlCode() {
        return this.glCode.get();
    }

    @Override
    @Transient
    public String getGlAccountCode() {
        return this.glCode.get().getGlCode();
    }

    public boolean hasGLCode() {
        return this.glCode.get() != null && this.glCode.get().getGlCode() != null && !this.glCode.get().getGlCode().equalsIgnoreCase("");
    }

    public void setGlCode(GLAccount glAccount) {
        this.glCode.set(glAccount);
    }

    @Override
    public void delete() {
        throw new NotImplementedException("cannot delete finance accounting groups");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property MEMO;
        public PropertiedObject.Property<GLAccount> GL_CODE;
    }
}

