/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FilterItemGroup;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.FinalPriceInvAdjustment;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.transactions.CreditTransactionHelper;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.unorderable.UnorderableSalesItemFactory;

public class FinanceSurchargeCalculator {
    public static final String FINAL_SURCHARGE_LABEL_SEPARATOR = " - ";

    private FinanceSurchargeCalculator() {
    }

    public static Price calculateSurcharge(Price amountPaid, Price amountTip, FinanceUnit unit) {
        Price surcharge = Price.ZERO_DOLLAR;
        if (unit != null && unit.getSurcharge() > 1.0E-7 && amountPaid.add(amountTip).greaterThan(Price.ZERO_DOLLAR)) {
            double total = amountPaid.doubleValue() + amountTip.doubleValue();
            if (unit.isUsesEftpos() && AdyenIntegrationConfig.getInstance().isConfigured()) {
                double amount = total * unit.getSurcharge();
                amount = MathsUtils.roundDownAsCents(amount);
                surcharge = new Price(amount, 0.01);
            } else {
                surcharge = new Price(total * unit.getSurcharge(), 0.01);
            }
        }
        return surcharge;
    }

    public static void applySurcharge(Payable group, FinanceUnit unit, Price amount, EventContext context) {
        if (amount == null || amount.isZero() || amount.lessThan(Price.ZERO_DOLLAR)) {
            return;
        }
        if (group instanceof PriceAdjustable) {
            if (group instanceof ItemGroup) {
                CreditTransactionHelper helper = new CreditTransactionHelper();
                ItemGroup itemGroup = (ItemGroup)group;
                if (helper.shouldCreateUnorderableItem(itemGroup, true)) {
                    itemGroup.getItemHelper().addItem(UnorderableSalesItemFactory.createUnorderableSalesItem(context));
                } else if (helper.shouldRemoveUnorderableItem(itemGroup)) {
                    itemGroup.getItemHelper().removeItem(helper.getUnorderableItem(itemGroup), context);
                }
            }
            FinanceSurchargeCalculator.applyAsPriceAdjustable((PriceAdjustable)((Object)group), unit, amount, context);
        } else if (group instanceof DebtorPaymentAgent) {
            FinanceSurchargeCalculator.applyAsDebtor((DebtorPaymentAgent)group, amount, context);
        } else {
            throw new IllegalStateException("Unknown surchargeable class:" + group.getClass());
        }
    }

    private static void applyAsPriceAdjustable(PriceAdjustable group, FinanceUnit unit, Price amount, EventContext context) {
        FinalPriceInvAdjustment finalSurcharge = PriceAdjustmentManager.getInstance().getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier.FINANCE, unit);
        FinalSalesPriceAdjustment existingAdj = null;
        if (group instanceof FilterItemGroup) {
            Account account = ((FilterItemGroup)group).parentAccount;
            existingAdj = (FinalSalesPriceAdjustment)account.getPriceAdjustment(finalSurcharge);
        } else {
            existingAdj = (FinalSalesPriceAdjustment)group.getPriceAdjustment(finalSurcharge);
        }
        if (existingAdj != null) {
            group.removePriceAdjustment(existingAdj, context);
            finalSurcharge.setAmount(amount.add(existingAdj.getDollarAmount()));
        } else {
            finalSurcharge.setAmount(amount);
        }
        SalesPriceAdjustment adj = ((InventoryPriceAdjustment)finalSurcharge).createSalesPriceAdjustment(group, context);
        adj.setLabel(unit.getLabel() + FINAL_SURCHARGE_LABEL_SEPARATOR + finalSurcharge.getDollarAmount().abs().toString(true));
    }

    private static void applyAsDebtor(DebtorPaymentAgent group, Price amount, EventContext context) {
        group.addFinanceTransaction(DebtorAdjustmentTransaction.createDebtorSurchargeTransaction(new FinanceTransactionContext(context), amount));
    }

    public static void removeSurcharge(Payable group, Price amount, EventContext context, FinanceUnit unit) {
        if (amount == null || amount.isZero() || amount.lessThan(Price.ZERO_DOLLAR)) {
            return;
        }
        if (group instanceof PriceAdjustable) {
            FinanceSurchargeCalculator.removeAsPriceAdjustable((PriceAdjustable)((Object)group), amount, context, unit);
        } else if (group instanceof DebtorPaymentAgent) {
            FinanceSurchargeCalculator.removeAsDebtor((DebtorPaymentAgent)group, amount, context);
        } else {
            throw new IllegalStateException("Unknown surchargeable class:" + group.getClass());
        }
    }

    private static void removeAsPriceAdjustable(PriceAdjustable group, Price amount, EventContext context, FinanceUnit unit) {
        FinalPriceInvAdjustment finalSurcharge = PriceAdjustmentManager.getInstance().getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier.FINANCE, unit);
        FinalSalesPriceAdjustment existingAdj = (FinalSalesPriceAdjustment)group.getPriceAdjustment(finalSurcharge);
        if (existingAdj != null) {
            group.removePriceAdjustment(existingAdj, context);
            Price newAmount = existingAdj.getDollarAmount().subtract(amount);
            if (!newAmount.isZero() && newAmount.greaterThan(Price.ZERO_DOLLAR)) {
                finalSurcharge.setAmount(newAmount);
                ((InventoryPriceAdjustment)finalSurcharge).createSalesPriceAdjustment(group, context);
            }
        } else {
            OrderMate.LOG.warn("Cannot remove finance surcharge since there was never a surcharge to begin with.");
        }
    }

    private static void removeAsDebtor(DebtorPaymentAgent agent, Price amount, EventContext context) {
        DebtorAdjustmentTransaction toRemove = null;
        for (FinanceTransaction txn : agent.getFinanceTransactions()) {
            if (!"ACCOUNT".equals(txn.getType()) || !txn.getPaid().equals(amount.negate())) continue;
            toRemove = (DebtorAdjustmentTransaction)txn;
        }
        if (toRemove != null) {
            agent.removeFinanceTransaction(toRemove);
        } else {
            OrderMate.LOG.warn("Cannot find surcharge to be removed for the transaction.");
        }
    }

    public static boolean shouldApplyPreSurcharge(FinanceTransaction txn) {
        EftposTransaction eftposTxn;
        VirtualEftpos vEftpos;
        return !(txn instanceof EftposTransaction) || (vEftpos = (eftposTxn = (EftposTransaction)txn).getVirtualEftpos()) == null || !vEftpos.isAutoSurcharge() || !Price.ZERO_DOLLAR.lessThan(eftposTxn.getPaid());
    }
}

