/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.database.DatabaseService;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.finance.reports.RestaurantTakingsSummaryQueries;
import ordermate.database.queries.finance.voucher.VoucherTransactionQueries;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class RestaurantTakingsSummaryCreator {
    private final DatabaseService service;
    private final Shift shift;
    private final DBConnectionInterface dc;
    private RestaurantTakingsSummary summary;

    public RestaurantTakingsSummaryCreator(DatabaseService service, DBConnectionInterface dc, Shift shift) {
        this.service = service;
        this.dc = dc;
        this.shift = shift;
    }

    public RestaurantTakingsSummary createSummary() {
        this.summary = new RestaurantTakingsSummary(this.shift);
        try {
            this.doTotalTakings();
            this.doCashdrawerTotals();
            this.doAppliedPreviousTransactions();
            this.doPaymentAndTips();
            this.summary.calculateDebtorTotals();
            for (SalesLocation location : SalesLocation.getSalesLocations()) {
                RestaurantTakingsSummary.LocationSales sales = new RestaurantTakingsSummary.LocationSales(location);
                this.summary.addLocationSales(location, sales);
                for (InventoryCategory category : InventoryCategory.getAllCategories()) {
                    sales.addSales(category.getName(), new Price(0.0, 0.01), 0);
                }
            }
            this.doCategories();
        }
        catch (SQLException e) {
            this.service.handleSQLError(e);
        }
        return this.summary;
    }

    private void doPaymentAndTips() throws SQLException {
        Object[] params = new Object[]{this.shift.getID()};
        this.summary.setLoyalty(new Price(this.service.getSumQueryResult(this.getGetTotalLoyaltyPS(), params, "total"), 0.01));
        params = new Object[]{this.shift.getID(), "CASH"};
        this.summary.setCashTips(this.service.getSumQueryResult(this.getGetRestaurantTipsPS(1), params, "total"));
        params = new Object[]{this.shift.getID(), "CREDIT", "DEBIT"};
        this.summary.setCardTips(this.service.getSumQueryResult(this.getGetRestaurantTipsPS(2), params, "total"));
        params = new Object[]{this.shift.getID(), "WEB"};
        this.summary.setWebTips(this.service.getSumQueryResult(this.getGetRestaurantTipsPS(1), params, "total"));
        params = new Long[]{this.shift.getID()};
        this.summary.setTotalTips(this.service.getSumQueryResult(this.getGetRestaurantTotalTipsPS(), params, "total"));
        PriceReport report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherTopupsSum(this.shift).toString());
        this.summary.setTotalVoucherTopups(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherRedeemsSum(this.shift).toString());
        this.summary.setTotalVoucherRedeems(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherTopupReversalsSum(this.shift).toString());
        this.summary.setTotalVoucherTopupReversals(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
        report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherRedeemReversalsSum(this.shift).toString());
        this.summary.setTotalVoucherRedeemReversals(report != null ? report.getPrice() : Price.ZERO_DOLLAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTotalTakings() throws SQLException {
        ResultSet rs = this.dc.executeQuery(RestaurantTakingsSummaryQueries.getTotalsPS().toString(), this.shift.getID());
        try {
            while (rs.next()) {
                double total = rs.getDouble("total");
                this.summary.setTotalTakings(total);
            }
        }
        finally {
            this.dc.release(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCashdrawerTotals() throws SQLException {
        Object[] params = new Object[]{this.shift.getID()};
        ResultSet rs = this.dc.executeQuery(RestaurantTakingsSummaryQueries.getCashdrawerTotalsPS().toString(), params);
        try {
            while (rs.next()) {
                double total = rs.getDouble("total");
                long cashDrawerID = rs.getLong("ID");
                CashDrawer drawer = PersistenceManager.getByID(cashDrawerID, CashDrawer.class);
                this.summary.setCashdrawerTakings(drawer, total);
            }
        }
        finally {
            this.dc.release(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCategories() throws SQLException {
        HashMap<Long, RestaurantTakingsSummary.LocationSales> locSalesMap = new HashMap<Long, RestaurantTakingsSummary.LocationSales>();
        for (RestaurantTakingsSummary.LocationSales sales : this.summary.getLocationSales()) {
            locSalesMap.put(sales.getLocation().getID(), sales);
        }
        Object[] params = new Object[]{this.shift.getID()};
        ResultSet rs = null;
        try {
            rs = this.dc.executeQuery(this.getGetSalesByLocationPS().toString(), params);
            while (rs.next()) {
                Object category = rs.getString("name");
                double incTotal = rs.getDouble("inc_total");
                double exTotal = rs.getDouble("ex_total");
                int numItems = rs.getInt("numItems");
                Long currentSalesLocation = rs.getLong("fk_config_sales_location");
                RestaurantTakingsSummary.LocationSales sales = (RestaurantTakingsSummary.LocationSales)locSalesMap.get(currentSalesLocation);
                if (sales == null) {
                    OrderMate.LOG.info("Sales from Deleted Sales Location " + currentSalesLocation + " will be added to default Terminal Location");
                    SalesLocation defaultLocation = SalesLocation.getDefaultSalesLocation();
                    OrderMate.LOG.info("Allocating Sales of Deleted SalesLocation " + currentSalesLocation + " to the default SalesLocation " + defaultLocation.getLabel() + " IncTotal : " + incTotal + " Ex Total " + exTotal);
                    sales = (RestaurantTakingsSummary.LocationSales)locSalesMap.get(defaultLocation.getID());
                }
                if (category == null || ((String)category).isEmpty()) {
                    category = InventoryCategory.getDefaultCategory().getLabel();
                }
                sales.addSales((String)category, new Price(incTotal, 0.01), numItems);
                sales.addSalesExDiscounts((String)category, new Price(exTotal, 0.01), numItems);
            }
            for (RestaurantTakingsSummary.LocationSales sales : locSalesMap.values()) {
                sales.putLastOrClear(InventoryCategory.getDefaultCategory().getLabel());
            }
        }
        catch (Throwable throwable) {
            this.dc.release(rs);
            throw throwable;
        }
        this.dc.release(rs);
        if (SystemProperty.getInstance().isCombosAsDiscount()) {
            try {
                rs = this.dc.executeQuery(this.getSalesByLocationExComboDiscountsSupplement().toString(), new Object[0]);
                while (rs.next()) {
                    double total = rs.getDouble("total");
                    String category = rs.getString("name");
                    if (category == null || category.isEmpty()) {
                        category = InventoryCategory.getDefaultCategory().getLabel();
                    }
                    Long location = rs.getLong("location");
                    RestaurantTakingsSummary.LocationSales sales = (RestaurantTakingsSummary.LocationSales)locSalesMap.get(location);
                    sales.addSalesExDiscounts(category, new Price(total, 0.01), 0);
                }
            }
            finally {
                this.dc.release(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppliedPreviousTransactions() throws SQLException {
        Date from = this.shift.getTradingDay().getOpenDateTime();
        Date to = this.shift.getTradingDay().getCloseDateTime();
        if (to == null) {
            to = new Date();
        }
        ResultSet rs = this.dc.executeQuery(this.getAppliedPreviousTransactions().toString(), from, to, from, to);
        try {
            rs.next();
            this.summary.setAppliedPreviousTransactionsToday(new Price(rs.getDouble("other"), 0.01));
            this.summary.setAppliedPreviousTransactions(new Price(rs.getDouble("rangeTotal"), 0.01));
        }
        finally {
            this.dc.release(rs);
        }
    }

    private ObjectQuery getGetRestaurantTipsPS(int typeCount) {
        StringBuilder SB = new StringBuilder("SELECT SUM(tip) AS total ");
        SB.append("FROM finance_transaction ").append("WHERE FK_finance_shift = ? ");
        if (typeCount > 1) {
            SB.append("AND type IN (");
            for (int i = 0; i < typeCount; ++i) {
                SB.append("?");
                if (i >= typeCount - 1) continue;
                SB.append(", ");
            }
            SB.append(") ");
        } else {
            SB.append("AND type = ? ");
        }
        SB.append("AND system_state = 'ACTIVE'");
        return new ObjectQuerySQLAdapter(SB.toString());
    }

    private ObjectQuery getGetRestaurantTotalTipsPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(tip) AS total FROM finance_transaction WHERE FK_finance_shift = ? AND system_state = 'ACTIVE'");
    }

    private ObjectQuery getSalesByLocationExComboDiscountsSupplement() {
        return Query.select(InventoryCategory.Properties.LABEL, "name").selectFunc("SUM(IF(sales_component.open_price IS NOT NULL AND sales_combo.id IS NOT NULL AND sales_combo.type NOT IN ('SalesAdjustmentCombo', 'SimpleCombo'), sales_component.menu_price - sales_component.open_price, 0) * sales_item_quantity.quantity) as total").select(SalesItemQuantity.Properties.SALES_LOCATION, "location").from("sales_item", "sales_combo").from("inventory_item", "inventory_item").linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing("sales_item", "fk_sales_combo", "sales_combo", "ID").linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).joinLeft(InventoryCategory.class, InventoryItem.Properties.CATEGORY).equals(Account.Properties.SHIFT, this.shift).groupBy(InventoryCategory.Properties.ID).groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
    }

    private ObjectQuery getSalesByLocationNoCategoryExDiscountComboDiscountsSupplement(SalesLocation location) {
        return Query.select(InventoryItem.Properties.ID).selectFunc("SUM(IF(sales_component.open_price IS NOT NULL AND sales_combo.id IS NOT NULL AND sales_combo.type NOT IN ('SalesAdjustmentCombo', 'SimpleCombo'), sales_component.menu_price - sales_component.open_price, 0) * sales_item_quantity.quantity) as total").from("sales_item", "sales_combo").linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing("sales_item", "fk_sales_combo", "sales_combo", "ID").linkUsing(SalesItem.Properties.ACCOUNT).equals(Account.Properties.SHIFT, this.shift).isNull(InventoryItem.Properties.CATEGORY).equals(SalesItemQuantity.Properties.SALES_LOCATION, location);
    }

    private ObjectQuery getGetSalesByLocationPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(sales_item_quantity.quantity) as numItems, SUM(" + this.getBasePriceForSalesComponentQueryFragment() + " * sales_item_quantity.quantity) as ex_total, SUM(sales_component.unit_price * sales_item_quantity.quantity) as inc_total,inventory_category.name as name, sales_item_quantity.fk_config_sales_location as fk_config_sales_location FROM  sales_item_quantity  inner join sales_item ON sales_item_quantity.FK_sales_item = sales_item.ID  inner join sales_component ON sales_component.FK_sales_item = sales_item.ID  inner join inventory_item ON sales_component.FK_inventory_item = inventory_item.ID  LEFT join inventory_category ON inventory_category.ID = inventory_item.FK_inventory_category  inner join sales_account ON sales_account.ID = sales_item.FK_sales_account WHERE sales_account.FK_finance_shift = ? GROUP BY inventory_category.ID, sales_item_quantity.fk_config_sales_location ORDER BY inventory_category.ID, sales_item_quantity.fk_config_sales_location ");
    }

    private ObjectQuery getGetTotalLoyaltyPS() {
        return new ObjectQuerySQLAdapter("SELECT SUM(finance_transaction.amount_paid) as total FROM finance_transaction, finance_unit WHERE finance_transaction.paid = 1 AND finance_transaction.FK_finance_unit = finance_unit.ID AND finance_unit.unit_type = 'LOYALTY' AND finance_transaction.system_state = 'ACTIVE' AND finance_transaction.FK_finance_shift = ? ");
    }

    private ObjectQuery getAppliedPreviousTransactions() {
        return new ObjectQuerySQLAdapter("SELECT SUM( if(finance_transaction.timestamp BETWEEN ? AND ?, finance_transaction.amount_paid, 0)) as 'rangeTotal', SUM( if(finance_transaction.timestamp BETWEEN ? AND ?, 0, finance_transaction.amount_paid)) as 'other' from finance_transaction inner join finance_transaction as linked_transaction on finance_transaction.fk_finance_transaction = linked_transaction.id inner join debtor_payment on linked_transaction.id=debtor_payment.FK_finance_transaction left join sales_account on sales_account.id = finance_transaction.fk_payoff_account where sales_account.fk_finance_shift = " + this.shift.getID() + " AND finance_transaction.system_state = 'ACTIVE'");
    }

    private String getBasePriceForSalesComponentQueryFragment() {
        String basePrice = "(sales_component.unit_price + sales_component.account_surcharge_total + sales_component.account_discount_total + sales_component.item_discount_total)";
        return basePrice;
    }
}

