/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.finance.ShiftQueries;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="finance_shift")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Shift
extends PersistentObject
implements Saveable,
Comparable,
Displayable {
    public static final Props Properties = new Props();
    private PersistentList<Terminal> terminals;
    private Reference<TradingDay> tradingDay;
    private Reference<ConfigShift> configShift;
    private String name;

    private Shift(TradingDay day, ConfigShift shiftConfig) {
        this.terminals = this.createList(Shift.Properties.TERMINALS);
        this.tradingDay = this.createReference(Shift.Properties.TRADING_DAY);
        this.configShift = this.createReference(Shift.Properties.CONFIG_SHIFT);
        this.tradingDay.set(day);
        this.setConfigShift(shiftConfig);
        this.name = shiftConfig.getLabel();
    }

    public Shift() {
        this.terminals = this.createList(Shift.Properties.TERMINALS);
        this.tradingDay = this.createReference(Shift.Properties.TRADING_DAY);
        this.configShift = this.createReference(Shift.Properties.CONFIG_SHIFT);
    }

    @Override
    public void init() {
        super.init();
        this.getLabel();
    }

    @OneToMany(mappedBy="shift", targetEntity=Terminal.class)
    public List<Terminal> getTerminals() {
        return this.terminals.getUnmodifiable();
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_shift")
    public ConfigShift getConfigShift() {
        return this.configShift.get();
    }

    protected void setConfigShift(ConfigShift shiftConfig) {
        this.configShift.set(shiftConfig);
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.getTradingDay() == null) {
            OrderMate.LOG.error("Shift should not have null trading day.  ID : " + this.getID());
            return "Missing Trading Day - " + this.name;
        }
        return this.getTradingDay().getLabel() + " - " + this.name;
    }

    public void addTerminal(Terminal toAdd) {
        if (!this.terminals.contains(toAdd)) {
            this.terminals.add(toAdd);
            toAdd.save();
            SystemCurrentInfo.setUpdate(toAdd.getName() + "added to the shift");
        }
    }

    public static Shift createShift(TradingDay day, ConfigShift shiftConfig) {
        Shift shift = new Shift(day, shiftConfig);
        shift.save();
        return shift;
    }

    public static Shift createShift(TradingDay day, ConfigShift configShift, String missingShift) {
        Shift shift = new Shift(day, configShift);
        shift.setName(missingShift);
        shift.save();
        return shift;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Shifts cannot be deleted.");
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    public static Shift getCurrentShift() {
        return PersistenceManager.getObject(Shift.class, ShiftQueries.getCurrentShift().toString());
    }

    public static Shift getShift(TradingDay day, String name) {
        String sql = Query.select(Shift.class).equals(Shift.Properties.TRADING_DAY, day).equals(ConfigShift.Properties.LABEL, name).linkUsing(Shift.Properties.CONFIG_SHIFT).orderBy(Shift.Properties.ID).toString();
        Shift shift = PersistenceManager.getObject(Shift.class, sql, null);
        return shift;
    }

    public static Shift getShift(TradingDay day, ConfigShift configShift) {
        String sql = Query.select(Shift.class).equals(Shift.Properties.TRADING_DAY, day).equals(Shift.Properties.CONFIG_SHIFT, configShift).orderBy(Shift.Properties.ID).toString();
        Shift shift = PersistenceManager.getObject(Shift.class, sql, null);
        return shift;
    }

    @Deprecated
    public static Shift getLastShiftClosedOnOrBefore(Date endDate) {
        return PersistenceManager.getObject(Shift.class, ShiftQueries.getLastShiftClosedOnOrBefore(endDate).toString());
    }

    public static Shift getLastShiftForDate(Date date) {
        return PersistenceManager.getObject(Shift.class, ShiftQueries.getLastShiftForDate(date).toString());
    }

    public static Shift getLastShiftClosedInBetween(Date startDate, Date endDate) {
        return PersistenceManager.getObject(Shift.class, ShiftQueries.getLastShiftClosedInBetween(startDate, endDate).toString());
    }

    public static Shift getFirstShiftForDate(Date startDate) {
        return PersistenceManager.getObject(Shift.class, ShiftQueries.getFirstShiftForDate(startDate).toString());
    }

    public static List<Shift> getShiftsForDate(Date theDate) {
        return PersistenceManager.getObjectList(Shift.class, ShiftQueries.getShiftsForDate(theDate).toString());
    }

    public static boolean hasShift(TradingDay day, String name) {
        return Shift.getShift(day, name) != null;
    }

    public static String[] getShiftNames() {
        Object[][] rawNames = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT config_shift.Name FROM config_shift WHERE system_state = 'ACTIVE' ORDER BY sequence", new Object[0]);
        String[] shiftNames = new String[rawNames.length];
        for (int i = 0; i < shiftNames.length; ++i) {
            shiftNames[i] = (String)rawNames[i][0];
        }
        return shiftNames;
    }

    public static List<Shift> getShifts() {
        String sql = Query.select(Shift.class).orderBy(Shift.Properties.ID).toString();
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, sql, null);
        return shifts;
    }

    public static List<Shift> getAllShiftsFor(Date from, Date to) {
        ArrayList<Shift> shifts = new ArrayList<Shift>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        do {
            shifts.addAll(Shift.getShiftsForDate(cal.getTime()));
            cal.add(5, 1);
        } while (cal.getTime().before(to));
        return shifts;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    protected void setTerminals(List<Terminal> terms) {
        this.terminals = this.terminals.clone();
        this.terminals.set(terms);
    }

    protected void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public int compareTo(Object o) {
        if (o instanceof Shift) {
            if (this.getTradingDay().getOpenDateTime().before(((Shift)o).getTradingDay().getOpenDateTime())) {
                return -1;
            }
            if (this.getTradingDay().getOpenDateTime().after(((Shift)o).getTradingDay().getOpenDateTime())) {
                return 1;
            }
            this.getConfigShift().getSequence().compareTo(((Shift)o).getConfigShift().getSequence());
        }
        return 1;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return null;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Terminal> TERMINALS;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<ConfigShift> CONFIG_SHIFT;
        public PropertiedObject.Property<String> NAME;
    }
}

