/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_skim")
@AccessType(value="property")
public class Skim
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<User> user;
    private Reference<CashDrawer> cashDrawer;
    private Reference<Shift> shift;
    private Reference<TradingDay> tradingDay;
    private Date creationTime;
    private SystemState systemState;
    private Date localCreationTime;
    private static final DateTimeUtils.ThreadLocalDateFormat formatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("h:mm a, dd MMM yyyy"));
    private PersistentWriteableList<SkimTransaction> transactions;

    public Skim() {
        this.user = this.createReference(Skim.Properties.USER);
        this.cashDrawer = this.createReference(Skim.Properties.CASH_DRAWER);
        this.shift = this.createReference(Skim.Properties.SHIFT);
        this.tradingDay = this.createReference(Skim.Properties.TRADING_DAY);
        this.creationTime = null;
        this.systemState = SystemState.ACTIVE_STATE;
        this.localCreationTime = new Date();
        this.transactions = (PersistentWriteableList)this.createList(Skim.Properties.TRANSACTIONS);
    }

    public Skim(User theUser, Shift theShift, CashDrawer theDrawer) {
        this.user = this.createReference(Skim.Properties.USER);
        this.cashDrawer = this.createReference(Skim.Properties.CASH_DRAWER);
        this.shift = this.createReference(Skim.Properties.SHIFT);
        this.tradingDay = this.createReference(Skim.Properties.TRADING_DAY);
        this.creationTime = null;
        this.systemState = SystemState.ACTIVE_STATE;
        this.localCreationTime = new Date();
        this.transactions = (PersistentWriteableList)this.createList(Skim.Properties.TRANSACTIONS);
        this.setUser(theUser);
        this.setShift(theShift);
        this.setCashDrawer(theDrawer);
        this.setTradingDay(theShift.getTradingDay());
    }

    public Skim(FinanceTransactionContext ctx) {
        this.user = this.createReference(Skim.Properties.USER);
        this.cashDrawer = this.createReference(Skim.Properties.CASH_DRAWER);
        this.shift = this.createReference(Skim.Properties.SHIFT);
        this.tradingDay = this.createReference(Skim.Properties.TRADING_DAY);
        this.creationTime = null;
        this.systemState = SystemState.ACTIVE_STATE;
        this.localCreationTime = new Date();
        this.transactions = (PersistentWriteableList)this.createList(Skim.Properties.TRANSACTIONS);
        this.setUser(ctx.getUser());
        this.setShift(ctx.getShift());
        this.setCashDrawer(ctx.getCashDrawer());
        this.setTradingDay(ctx.getTradingDay());
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    public void setUser(User newUser) {
        this.user.set(newUser);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_cashdrawer")
    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer newDrawer) {
        this.cashDrawer.set(newDrawer);
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    public void setShift(Shift newShift) {
        this.shift.set(newShift);
    }

    @Column(name="system_state")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    public SystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay newDay) {
        this.tradingDay.set(newDay);
    }

    @Transient
    public String getCreationTimeAsString() {
        Date time = this.creationTime != null ? this.creationTime : this.localCreationTime;
        return formatter.getFormat().format(time);
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        Date time = this.creationTime != null ? this.creationTime : this.localCreationTime;
        return time;
    }

    public SkimTransaction addTransaction(Price amount, FinanceUnit type) {
        SkimTransaction newTransaction = new SkimTransaction();
        newTransaction.setAmount(amount);
        newTransaction.setFinanceUnit(type);
        newTransaction.setSkim(this);
        this.transactions.add(newTransaction);
        return newTransaction;
    }

    public void removeTransaction(SkimTransaction txn) {
        if (this.equals(txn.getSkim())) {
            if (txn.isPersistent()) {
                txn.setSystemState(SystemState.DELETED_STATE);
            } else {
                this.transactions.remove(txn);
            }
        }
    }

    @Transient
    public List<SkimTransaction> getActiveTransactions() {
        ArrayList<SkimTransaction> activeList = new ArrayList<SkimTransaction>();
        for (SkimTransaction txn : this.transactions) {
            if (!SystemState.ACTIVE_STATE.equals(txn.getSystemState())) continue;
            activeList.add(txn);
        }
        return activeList;
    }

    @Transient
    public List<SkimTransaction> getAllTransactions() {
        return this.transactions.getUnmodifiable();
    }

    @OneToMany(mappedBy="skim", targetEntity=SkimTransaction.class)
    public List<SkimTransaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            this.localCreationTime = new Date();
        }
        PersistenceManager.save(this);
        this.transactions.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        for (SkimTransaction txn : this.transactions) {
            txn.deleteChild();
        }
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static List<Skim> getSkims(Shift theShift, CashDrawer theDrawer) {
        return PersistenceManager.getObjectList(Skim.class, "SELECT finance_skim.* FROM finance_skim WHERE FK_finance_shift = ? AND FK_config_cashdrawer = ? AND system_state = 'ACTIVE' ", new Object[]{theShift.getID(), theDrawer.getID()});
    }

    @Transient
    public Price getTotal() {
        Price total = Price.ZERO_DOLLAR;
        for (SkimTransaction txn : this.getActiveTransactions()) {
            total = total.add(txn.getAmount());
        }
        return total;
    }

    public Price getTotalForSubType(FinanceUnit type) {
        for (SkimTransaction txn : this.getActiveTransactions()) {
            if (!txn.getFinanceUnit().equals(type)) continue;
            return txn.getAmount();
        }
        return Price.ZERO_DOLLAR;
    }

    protected void setCreationTime(Date time) {
        this.creationTime = time;
    }

    protected void setTransactions(List<SkimTransaction> trans) {
        this.transactions = this.transactions.clone();
        this.transactions.set(trans);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<SkimTransaction> TRANSACTIONS;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

