/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransactionEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_skim_transaction")
@AccessType(value="property")
public class SkimTransaction
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Price amount;
    private Reference<Skim> skim;
    private Reference<FinanceUnit> financeUnit;
    private SystemState systemState;
    private PersistentWriteableList<SkimTransactionEntry> entries;

    public SkimTransaction() {
        this.skim = this.createReference(SkimTransaction.Properties.SKIM);
        this.financeUnit = this.createReference(SkimTransaction.Properties.FINANCE_UNIT);
        this.systemState = SystemState.ACTIVE_STATE;
        this.entries = this.createWriteableList(SkimTransaction.Properties.ENTRIES);
    }

    @Column(name="amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price newAmount) {
        this.amount = newAmount;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_skim")
    public Skim getSkim() {
        return this.skim.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_unit")
    public FinanceUnit getFinanceUnit() {
        return this.financeUnit.get();
    }

    public void setFinanceUnit(FinanceUnit newType) {
        this.financeUnit.set(newType);
    }

    @Column(name="system_state")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    public SystemState getSystemState() {
        return this.systemState;
    }

    protected void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @OneToMany(mappedBy="skimTransaction", targetEntity=SkimTransactionEntry.class)
    public List<SkimTransactionEntry> getEntries() {
        return this.entries;
    }

    protected void setEntries(List<SkimTransactionEntry> values) {
        this.entries = this.entries.clone();
        this.entries.set(values);
    }

    public void setEntry(Denomination den, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot have a negative count");
        }
        if (den == null) {
            throw new IllegalArgumentException("Cannot have a null denomination");
        }
        SkimTransactionEntry entry = this.getEntryFor(den);
        if (count == 0) {
            if (entry != null) {
                entry.updateCount(0);
                this.entries.remove(entry);
            }
        } else if (entry == null) {
            entry = new SkimTransactionEntry(this, den, count);
            this.entries.add(entry);
        } else {
            entry.updateCount(count);
        }
        this.recalculate();
    }

    private SkimTransactionEntry getEntryFor(Denomination den) {
        for (SkimTransactionEntry entry : this.entries) {
            if (!den.equals(entry.getDenomination())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.entries.saveChild();
    }

    @Override
    public void deleteChild() {
        this.systemState = SystemState.DELETED_STATE;
        this.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static List<SkimTransaction> getSkimTransactions(Shift shift) {
        return PersistenceManager.getObjectList(SkimTransaction.class, Query.select(SkimTransaction.class).linkUsing(SkimTransaction.Properties.SKIM).equals(Skim.Properties.SHIFT, shift.getID()).active(SkimTransaction.class).orderBy(SkimTransaction.Properties.SKIM).toString(), new Object[0]);
    }

    protected void setSkim(Skim skim) {
        if (skim != null) {
            this.skim.set(skim);
        }
    }

    public Price recalculate() {
        if (this.financeUnit.get().equals(FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE))) {
            double value = 0.0;
            for (SkimTransactionEntry entry : this.entries) {
                value = entry.getValue().doubleValue() + value;
            }
            this.amount = new Price(value, 0.01);
        }
        return this.amount;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Price> AMOUNT;
        public PropertiedObject.Property<Skim> SKIM;
        public PropertiedObject.Property<FinanceUnit> FINANCE_UNIT;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<SkimTransactionEntry> ENTRIES;
    }
}

