/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.finance.Denomination;
import ordermate.database.finance.SkimTransaction;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="finance_skim_transaction_entry")
@AccessType(value="property")
public class SkimTransactionEntry
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<SkimTransaction> skimTransaction;
    private Price value;
    private int unitCount;
    private Reference<Denomination> denomination;

    @Deprecated
    public SkimTransactionEntry() {
        this.skimTransaction = this.createReference(SkimTransactionEntry.Properties.SKIM_TRANSACTION);
        this.denomination = this.createReference(SkimTransactionEntry.Properties.DENOMINATION);
    }

    public SkimTransactionEntry(SkimTransaction txn, Denomination den, int count) {
        this.skimTransaction = this.createReference(SkimTransactionEntry.Properties.SKIM_TRANSACTION);
        this.denomination = this.createReference(SkimTransactionEntry.Properties.DENOMINATION);
        if (count < 0 || den == null) {
            throw new IllegalArgumentException("Cannot have a null denomination or a negative count");
        }
        this.setSkimTransaction(txn);
        this.setDenomination(den);
        this.updateCount(count);
    }

    @ManyToOne(targetEntity=SkimTransaction.class)
    @JoinColumn(name="fk_finance_skim_transaction")
    public SkimTransaction getSkimTransaction() {
        return this.skimTransaction.get();
    }

    protected void setSkimTransaction(SkimTransaction value) {
        this.skimTransaction.set(value);
    }

    @Column(name="value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getValue() {
        return this.value;
    }

    protected void setValue(Price amount) {
        this.value = amount;
    }

    @Column(name="unit_count")
    public int getUnitCount() {
        return this.unitCount;
    }

    protected void setUnitCount(int unitCount) {
        this.unitCount = unitCount;
    }

    public void updateCount(int newCount) {
        this.unitCount = newCount;
        this.value = new Price((double)newCount * this.getDenomination().getValue(), 0.01);
    }

    @ManyToOne(targetEntity=Denomination.class)
    @JoinColumn(name="fk_finance_denomination")
    public Denomination getDenomination() {
        return this.denomination.get();
    }

    protected void setDenomination(Denomination value) {
        this.denomination.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SkimTransaction> SKIM_TRANSACTION;
        public PropertiedObject.Property<Denomination> DENOMINATION;
        public PropertiedObject.Property<Integer> UNIT_COUNT;
        public PropertiedObject.Property<Price> VALUE;
    }
}

