/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.util.Price;
import java.util.HashSet;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.FilterItemGroup;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.FinalPriceAdjustmentIdentifier;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.FinalSalesPriceAdjustment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.Sellable;

public class SplitItemGroup
extends FilterItemGroup {
    public SplitItemGroup(Account newFilterGroup, List<Sellable> filterItems) {
        super("SPLIT BILL", newFilterGroup);
        this.initializeSellables(filterItems);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SplitItemGroup)) {
            return false;
        }
        SplitItemGroup other = (SplitItemGroup)obj;
        return this.parentAccount.equals(other.parentAccount);
    }

    @Override
    public Price getTotal() {
        this.checkNoDollarPriceAdjustment(this.parentAccount);
        double total = 0.0;
        for (SalesLineItem item : this.getItems()) {
            total += item.getPrice().doubleValue();
        }
        if (this.getAccount().hasVoucherTxnsChanged()) {
            for (GiftVoucherTransaction txn : this.voucherTransactions) {
                total += txn.getAmount().doubleValue();
            }
        }
        HashSet<FinanceUnit> usedUnits = new HashSet<FinanceUnit>();
        for (FinanceTransaction txn : this.parentAccount.getFinanceTransactions()) {
            usedUnits.add(txn.getSubType());
        }
        for (FinanceUnit unit : usedUnits) {
            FinalSalesPriceAdjustment finalSalesAdjustment = (FinalSalesPriceAdjustment)this.parentAccount.getPriceAdjustment(PriceAdjustmentManager.getInstance().getFinalPriceAdjustment(FinalPriceAdjustmentIdentifier.FINANCE, unit));
            total += this.getAmountForFinalPriceAdjustment(finalSalesAdjustment);
        }
        return new Price(total, 0.01).add(this.getTotalRoundingAmt());
    }

    private double getAmountForFinalPriceAdjustment(FinalSalesPriceAdjustment finalAdj) {
        if (finalAdj == null) {
            return 0.0;
        }
        double currentTotal = 0.0;
        HashSet<SalesPriceAdjustment> finalAdjustments = new HashSet<SalesPriceAdjustment>();
        for (SalesPriceAdjustment adj : this.parentAccount.getPriceAdjustments()) {
            if (!finalAdj.getInventoryPriceAdjustment().equals(adj.getInventoryPriceAdjustment())) continue;
            finalAdjustments.add(adj);
            currentTotal += adj.getValue().doubleValue();
        }
        double mySurchargeTotal = 0.0;
        for (FinanceTransaction txn : this.financeTransactions) {
            if (!txn.getSubType().equals(finalAdj.getInventoryPriceAdjustment().getFinanceUnit())) continue;
            mySurchargeTotal += txn.getSurcharge().doubleValue();
        }
        double totalAppliedToMyItems = 0.0;
        double totalAppliedToNotMyItems = 0.0;
        for (SalesLineItem lineItems : this.parentAccount.getItems()) {
            for (SalesItem item : lineItems.getSalesItems()) {
                for (SalesComponent comp : item.getComponentList()) {
                    for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
                        if (!finalAdjustments.contains(usage.getSalesPriceAdjustment())) continue;
                        if (this.containsItem(item)) {
                            totalAppliedToMyItems += usage.getValue().doubleValue();
                            continue;
                        }
                        totalAppliedToNotMyItems += usage.getValue().doubleValue();
                    }
                }
            }
        }
        return totalAppliedToMyItems + mySurchargeTotal;
    }

    private boolean containsItem(SalesItem item) {
        for (SalesLineItem lineItem : this.getActiveItemsModifiable()) {
            for (SalesItem salesItem : lineItem.getSalesItems()) {
                if (!salesItem.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allowsAdvancedPriceAdjustments() {
        return false;
    }

    @Override
    public void close(EventContext context) {
        this.parentAccount.close(context);
    }

    @Override
    public Customer getCustomer() {
        return this.parentAccount.getCustomer();
    }

    @Override
    public boolean hasCustomer() {
        return this.parentAccount.hasCustomer();
    }

    @Override
    public List setCustomer(Customer customer, EventContext context) {
        return this.parentAccount.setCustomer(customer, context);
    }

    @Override
    public boolean usesSeatNums() {
        return this.parentAccount.usesSeatNums();
    }

    @Override
    public int getNumPatrons() {
        return this.parentAccount.getNumPatrons();
    }

    @Override
    public boolean hasChanged() {
        return this.parentAccount.hasChanged();
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return this.parentAccount.allowsPayingIntoCredit();
    }

    @Override
    public boolean removePriceAdjustment(SalesPriceAdjustment adjustment, EventContext context) {
        boolean removed = false;
        for (SalesLineItem nextItem : this.items) {
            removed = nextItem.removePriceAdjustment(adjustment, context) || removed;
        }
        removed = this.parentAccount.removePriceAdjustment(adjustment, context) || removed;
        return this.adjustments.remove(adjustment) || removed;
    }

    @Override
    public int getOrderNumber() {
        return this.getAccount().getOrderNumber();
    }

    @Override
    public void updateCustomerReference() {
        this.parentAccount.updateCustomerReference();
    }
}

