/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance;

import au.com.ordermate.util.Price;

public class TransactionSummary {
    private final Price paid;
    private final Price tip;
    private final Price cashout;
    private final Price surcharge;
    private final Price total;
    private final Price due;

    public TransactionSummary(Price paid, Price tip, Price cashout, Price surcharge, Price due) {
        this.paid = paid != null ? paid : Price.ZERO_DOLLAR;
        this.tip = tip != null ? tip : Price.ZERO_DOLLAR;
        this.cashout = cashout != null ? cashout : Price.ZERO_DOLLAR;
        this.surcharge = surcharge != null ? surcharge : Price.ZERO_DOLLAR;
        this.total = new Price(this.paid.doubleValue() + this.tip.doubleValue() + this.surcharge.doubleValue(), 0.01);
        this.due = due;
    }

    public Price getPaid() {
        return this.paid;
    }

    public Price getTip() {
        return this.tip;
    }

    public Price getCashout() {
        return this.cashout;
    }

    public Price getSurcharge() {
        return this.surcharge;
    }

    public Price getTotal() {
        return this.total;
    }

    public Price getDue() {
        return this.due;
    }

    public static class TransactionSummaryBuilder {
        private Price paid = Price.ZERO_DOLLAR;
        private Price tip = Price.ZERO_DOLLAR;
        private Price cashout = Price.ZERO_DOLLAR;
        private Price surcharge = Price.ZERO_DOLLAR;
        private Price due = Price.ZERO_DOLLAR;

        public static TransactionSummaryBuilder start() {
            return new TransactionSummaryBuilder();
        }

        public TransactionSummaryBuilder paid(Price value) {
            this.paid = value;
            return this;
        }

        public TransactionSummaryBuilder tip(Price value) {
            this.tip = value;
            return this;
        }

        public TransactionSummaryBuilder cashout(Price value) {
            this.cashout = value;
            return this;
        }

        public TransactionSummaryBuilder surcharge(Price value) {
            this.surcharge = value;
            return this;
        }

        public TransactionSummaryBuilder due(Price value) {
            this.due = value;
            return this;
        }

        public TransactionSummary build() {
            return new TransactionSummary(this.paid, this.tip, this.cashout, this.surcharge, this.due);
        }
    }
}

