/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.RequiredFields;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.debtors.CustomerDebtorInterface;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.services.finance.debtors.DebtorSalesFilter;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="debtor")
@DiscriminatorColumn(name="Type")
@AccessType(value="property")
public abstract class AbstractDebtor
extends PersistentDisplayableObject
implements Saveable,
RequiredFields,
Lockable,
CreditLimited {
    public static final String OMO_DEBTOR = "OrderMate Online";
    public static final Props Properties = new Props();
    public static final List REQUIRED_FIELDS = Collections.unmodifiableList(Arrays.asList(AbstractDebtor.Properties.LABEL, AbstractDebtor.Properties.GROUP));
    public static final String ROOMTYPE = "ROOM";
    private final Color outstandingAmountColor = Displayable.PRINTED_COLOR;
    private final Color overdueAmountColor = Displayable.OVERDUE_COLOR;
    private Price amountOutstanding = new Price(0.0, 0.01);
    private Price creditLimit;
    private Date lastActivityDate = new Date();
    private Date earliestDueDate;
    private String systemState = "ACTIVE";
    private boolean noteRequired = false;
    private Reference<DebtorGroup> group;
    private Reference<User> user;
    private PersistentWriteableList<DebtorSale> paidSales;
    private PersistentWriteableList<DebtorSale> unpaidSales;
    private PersistentWriteableList<DebtorPayment> unsettledPayments;
    private PersistentList<DebtorPayment> allPayments;
    private List<DebtorPayment> delinkedPayments;

    public static String[] getTypes() {
        return new String[]{"SIMPLE", "CUSTOMER", "System", "Room"};
    }

    public static AbstractDebtor getDebtorByName(String name) {
        ObjectQuery select = Query.select(AbstractDebtor.class).active(AbstractDebtor.class).equals(AbstractDebtor.Properties.LABEL, name).limit(1);
        return PersistenceManager.getObject(AbstractDebtor.class, select.toString(), null);
    }

    public List getFinanceTransactions(Date from) {
        ObjectQuery select = Query.select(FinanceTransaction.class).distinct().active(FinanceTransaction.class).linkUsing(FinanceTransaction.Properties.DEBTOR_PAYMENTS).linkUsing(DebtorPayment.Properties.DEBTOR).equals(AbstractDebtor.Properties.ID, this.getID()).greaterThanOrEqual(FinanceTransaction.Properties.CREATION_TIME, from, SQLDateType.TIMESTAMP).orderBy(FinanceTransaction.Properties.CREATION_TIME);
        return PersistenceManager.getObjectList(FinanceTransaction.class, select.toString(), null);
    }

    @Transient
    public abstract String getType();

    @Override
    @Transient
    public abstract String getIcon();

    public AbstractDebtor() {
        this("");
    }

    public AbstractDebtor(String newLabel) {
        this.group = this.createReference(AbstractDebtor.Properties.GROUP);
        this.user = this.createReference(AbstractDebtor.Properties.USER);
        this.paidSales = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.PAID_SALES);
        this.unpaidSales = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.UNPAID_SALES);
        this.unsettledPayments = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.UNSETTLED_PAYMENTS);
        this.allPayments = this.createList(AbstractDebtor.Properties.ALL_PAYMENTS);
        this.delinkedPayments = new ArrayList<DebtorPayment>();
        this.setLabel(newLabel);
    }

    protected AbstractDebtor(AbstractDebtor other) {
        this.group = this.createReference(AbstractDebtor.Properties.GROUP);
        this.user = this.createReference(AbstractDebtor.Properties.USER);
        this.paidSales = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.PAID_SALES);
        this.unpaidSales = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.UNPAID_SALES);
        this.unsettledPayments = (PersistentWriteableList)this.createList(AbstractDebtor.Properties.UNSETTLED_PAYMENTS);
        this.allPayments = this.createList(AbstractDebtor.Properties.ALL_PAYMENTS);
        this.delinkedPayments = new ArrayList<DebtorPayment>();
        this.setLabel(other.getLabel());
        this.setCreditLimit(other.getCreditLimit());
        this.setGroup(other.getGroup());
        this.earliestDueDate = other.earliestDueDate;
        this.amountOutstanding = new Price(other.amountOutstanding, 0.01);
        this.lastActivityDate = other.lastActivityDate;
        if (other.isPersistent()) {
            PersistenceManager.setID(this, other.intID());
        }
    }

    @Transient
    public boolean isCreditLimited() {
        return true;
    }

    @Override
    public boolean exceedsCreditLimit(Price newSaleAmount) {
        if (!this.isCreditLimited()) {
            return false;
        }
        return this.getAmountOutstanding().add(newSaleAmount).greaterThan(this.getCreditLimit());
    }

    public boolean allowsPayingIntoCredit() {
        return true;
    }

    void addDebtorSale(DebtorSale sale) {
        this.unpaidSales.add(sale);
        sale.setDebtor(this);
    }

    void addUnsettledPayment(DebtorPayment payment) {
        this.unsettledPayments.remove(payment);
        this.unsettledPayments.add(payment);
        this.allPayments.add(payment);
    }

    public AbstractDebtor addCustomer(Customer newCustomer) {
        if (!this.canAddCustomer() && newCustomer != null) {
            throw new IllegalArgumentException("cannot added customer to debtor of type :" + this.getClass());
        }
        if (this instanceof CustomerDebtorInterface) {
            if (newCustomer != null) {
                ((CustomerDebtorInterface)((Object)this)).setCustomer(newCustomer);
                return this;
            }
            return ((CustomerDebtorInterface)((Object)this)).removeCustomer();
        }
        if (this instanceof SimpleDebtor && newCustomer != null) {
            return new CustomerDebtor(newCustomer, this);
        }
        if (newCustomer != null) {
            throw new ClassCastException("Cannot cast from " + this.getClass().toString() + " to CustomerDebtor");
        }
        return this;
    }

    public boolean canAddCustomer() {
        return this instanceof CustomerDebtorInterface || this instanceof SimpleDebtor;
    }

    public boolean hasCustomer() {
        return false;
    }

    public boolean hasTerms() {
        return false;
    }

    @Column(name="last_activity_date")
    @Temporal(value=TemporalType.DATE)
    public Date getLastActivityDate() {
        if (this.lastActivityDate == null) {
            return null;
        }
        return new Date(this.lastActivityDate.getTime());
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="credit_limit")
    public Price getCreditLimit() {
        if (this.creditLimit == null) {
            try {
                this.creditLimit = SystemProperty.getInstance().getTabCreditLimit();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot get default credit limit, defaulting to one dollar.");
                this.creditLimit = new Price(1.0, Price.DEFAULT_ROUND_AMOUNT);
            }
        }
        return this.creditLimit;
    }

    @Override
    public void setCreditLimit(Price newCreditLimit) {
        assert (!newCreditLimit.lessThan(Price.ZERO_DOLLAR)) : "Got limit of " + newCreditLimit.toString() + ", but credit limit can not be less than zero";
        if (!this.isCreditLimited()) {
            throw new IllegalStateException("Cannot set credit limit for this type of debtor: " + this.getType());
        }
        this.creditLimit = newCreditLimit;
    }

    @Override
    @Transient
    public Price getCreditLimitRemaining() {
        return this.getCreditLimit().subtract(this.getAmountOutstanding());
    }

    @Transient
    public List<DebtorSale> getSales() {
        return this.getAllSales();
    }

    @Transient
    protected List<DebtorSale> getAllSales() {
        ArrayList<DebtorSale> list = new ArrayList<DebtorSale>(this.unpaidSales.size() + this.paidSales.size());
        list.addAll(this.paidSales.getUnmodifiable());
        list.addAll(this.unpaidSales.getUnmodifiable());
        return list;
    }

    @OneToMany(mappedBy="debtor", targetEntity=DebtorSale.class)
    public List<DebtorSale> getPaidSales() {
        return this.paidSales.getUnmodifiable();
    }

    public List<DebtorSale> getFilteredSales(DebtorSalesFilter filter) {
        return filter.applyFilter(this.getAllSales());
    }

    @Transient
    public List<DebtorSale> getFilteredPaidSales(DebtorSalesFilter filter) {
        return filter.applyFilter(this.getPaidSales());
    }

    @Transient
    public List<DebtorSale> getFilteredUnpaidSales(DebtorSalesFilter filter) {
        return filter.applyFilter(this.getUnpaidSales());
    }

    @OneToMany(mappedBy="debtor", targetEntity=DebtorPayment.class)
    public List<DebtorPayment> getUnsettledPayments() {
        return this.unsettledPayments.getUnmodifiable();
    }

    @OneToMany(mappedBy="debtor", targetEntity=DebtorPayment.class)
    public List<DebtorPayment> getAllPayments() {
        return this.allPayments.getUnmodifiable();
    }

    @Transient
    Price getTotalUnsettledPayments() {
        Price total = new Price(0.0, 0.01);
        for (DebtorPayment payment : this.unsettledPayments) {
            total = total.add(payment.getAmount());
        }
        return total;
    }

    public DebtorSale addSale(Account sale, FinanceTransactionContext context, String invoiceNote) {
        if (sale.isOpen()) {
            throw new IllegalStateException("The account must be saved and closed before it can be added to the debtor sales.");
        }
        DebtorSale newSale = new DebtorSale(sale, this, context);
        newSale.setInvoiceNote(invoiceNote);
        this.unpaidSales.add(newSale);
        this.settleSales(new ArrayList<DebtorSale>());
        TerminalEventLog.getInst().logDebtorSale(context, this, sale);
        return newSale;
    }

    void removeSale(DebtorSale sale) {
        this.paidSales.remove(sale);
        this.unpaidSales.remove(sale);
    }

    void addPayment(FinanceTransaction payment, Price available) {
        DebtorPayment paymentToAdd = new DebtorPayment(this, payment, available);
        this.addUnsettledPayment(paymentToAdd);
        this.updateTotalDue();
    }

    public void removePayment(DebtorPayment paymentToRemove) {
        if (paymentToRemove != null) {
            this.allPayments.remove(paymentToRemove);
            this.unsettledPayments.remove(paymentToRemove);
            paymentToRemove.deleteChild();
            this.updateTotalDue();
        }
    }

    public void removeAllPayments() {
        List<DebtorPayment> payments = this.getAllPayments();
        for (DebtorPayment payment : payments) {
            payment.deleteChild();
        }
        this.allPayments.clear();
        this.unsettledPayments.clear();
        this.updateTotalDue();
    }

    public void addUnsettlePayment(DebtorPayment payment) {
        if (!payment.getDebtor().equals(this)) {
            throw new IllegalArgumentException("Attempt to unsettle a payment that does not belong to this debtor");
        }
        this.allPayments.remove(payment);
        this.addUnsettledPayment(payment);
    }

    @ManyToOne
    @JoinColumn(name="FK_debtor_group")
    public DebtorGroup getGroup() {
        return this.group.get();
    }

    public void setGroup(DebtorGroup newGroup) {
        if (newGroup != null && !newGroup.isPersistent()) {
            newGroup.setType(this.getType());
        }
        this.group.set(newGroup);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public Terms getTermsValue() {
        return new Terms(0);
    }

    public void setTermsValue(Terms newTerms) {
        newTerms.toString();
    }

    @Override
    public boolean getMeetsRequirements(List requirements) {
        return RequiredFields.RequiredFieldsValidator.validate(this, requirements);
    }

    @Override
    public boolean getMeetsRequirement(PropertiedObject.Property requiredProperty) {
        try {
            Object value = PropertyUtils.getProperty((Object)this, (String)requiredProperty.getName());
            if (value == null || value.toString() == null) {
                return false;
            }
            if (value.toString().length() > 0) {
                return true;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }

    public void updateTotalDue() {
        Iterator salesIt = this.unpaidSales.iterator();
        Price localOutstandingAmount = new Price(0.0, 0.01);
        this.earliestDueDate = null;
        while (salesIt.hasNext()) {
            DebtorSale currentSale = (DebtorSale)salesIt.next();
            if (!currentSale.isPaid()) {
                localOutstandingAmount = new Price(localOutstandingAmount.add(currentSale.getAmountOutstanding()), 0.01);
                if (this.earliestDueDate == null || this.earliestDueDate.after(currentSale.getDueDate())) {
                    this.earliestDueDate = currentSale.getDueDate();
                }
            }
            if (this.lastActivityDate != null && !this.lastActivityDate.before(currentSale.getSaleDate())) continue;
            this.lastActivityDate = currentSale.getSaleDate();
        }
        this.amountOutstanding = new Price(localOutstandingAmount.subtract(this.getTotalUnsettledPayments()), 0.01);
    }

    @Column(name="earliest_due_date")
    @Temporal(value=TemporalType.DATE)
    public Date getEarliestDueDate() {
        if (this.earliestDueDate == null) {
            return null;
        }
        return new Date(this.earliestDueDate.getTime());
    }

    private void setSystemState(SystemState state) {
        this.systemState = state.getSystemState();
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    public boolean hasOverdue() {
        Date now = new Date();
        if (!this.hasOutstanding() || this.earliestDueDate == null) {
            return false;
        }
        if (now.getYear() > this.earliestDueDate.getYear()) {
            return true;
        }
        if (now.getYear() == this.earliestDueDate.getYear()) {
            if (now.getMonth() > this.earliestDueDate.getMonth()) {
                return true;
            }
            if (now.getMonth() == this.earliestDueDate.getMonth() && now.getDate() > this.earliestDueDate.getDate()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasOutstanding() {
        return this.amountOutstanding.greaterThan(Price.ZERO);
    }

    public boolean hasCreditBalance() {
        return this.amountOutstanding.lessThan(Price.ZERO);
    }

    public boolean hasAmount() {
        return !this.amountOutstanding.isZero();
    }

    @Column(name="amount_outstanding")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getAmountOutstanding() {
        return this.amountOutstanding;
    }

    @Transient
    public boolean isActive() {
        return this.systemState.equalsIgnoreCase("ACTIVE");
    }

    public void printStatementDockets(EventContext context, Collection receiptPrinters) throws Exception {
        DocketProcessor.printStatementDocket(this.getUnpaidSales(), Price.ZERO, this.getLabel(), receiptPrinters);
        TerminalEventLog.logPrintStatement(context, this.getLabel());
    }

    public void printActivityStatementDockets(Date from, Date to, EventContext eventContext, Set printers) throws IOException {
        DocketProcessor.printActivityStatementDocket(this, from, to, printers);
        TerminalEventLog.logPrintStatement(eventContext, this.getLabel());
    }

    @OneToMany(mappedBy="debtor", targetEntity=DebtorSale.class)
    public List<DebtorSale> getUnpaidSales() {
        return this.unpaidSales.getUnmodifiable();
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (this.isLocked()) {
            return ACCOUNT_LOCKED;
        }
        if (this.hasOverdue()) {
            return this.overdueAmountColor;
        }
        if (this.hasOutstanding()) {
            return this.outstandingAmountColor;
        }
        if (this.hasCreditBalance()) {
            return Displayable.PAID_COLOR;
        }
        return super.getBackgroundColor();
    }

    @Override
    public void save() {
        this.getCreditLimit();
        if (this.systemState == null || this.systemState.equalsIgnoreCase("")) {
            this.systemState = "ACTIVE";
        }
        if (this.hasChanged()) {
            this.lastActivityDate = new Date();
        }
        this.updateTotalDue();
        this.amountOutstanding = new Price(this.amountOutstanding, 0.01);
        PersistenceManager.save(this);
        this.unsettledPayments.saveChild();
        this.unpaidSales.saveChild();
        this.paidSales.saveChild();
        this.group.saveChild();
        Iterator<DebtorPayment> it = this.delinkedPayments.iterator();
        while (it.hasNext()) {
            DebtorPayment payment = it.next();
            it.remove();
            payment.deleteChild();
        }
        this.paidSales.collapseUnsafe();
        this.unpaidSales.collapseUnsafe();
        this.unsettledPayments.collapseUnsafe();
    }

    @Override
    public void delete() {
        if (OMO_DEBTOR.equals(this.getLabelNoFormat())) {
            OrderMate.LOG.warn("Cannot delete the OrderMate Online debtor");
        } else {
            this.setSystemState(SystemState.DELETED_STATE);
            this.save();
        }
    }

    @Override
    public void setLabel(String value) {
        if (OMO_DEBTOR.equals(this.getLabelNoFormat())) {
            OrderMate.LOG.warn("Cannot rename the OrderMate Online debtor");
        } else {
            super.setLabel(value);
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    void settleSales(List<DebtorSale> selectedSales) {
        if (selectedSales.size() != 0) {
            ArrayList<DebtorSale> selectedUnpaidSales = new ArrayList<DebtorSale>(this.unpaidSales);
            selectedUnpaidSales.retainAll(selectedSales);
            DebtorSale.sortListForPayment(selectedUnpaidSales);
            this.settlePayments(selectedUnpaidSales);
        }
        DebtorSale.sortListForPayment(this.unpaidSales);
        this.settlePayments(this.unpaidSales);
    }

    private void settlePayments(List debtorSales) {
        Iterator saleIt = debtorSales.iterator();
        block0: while (saleIt.hasNext()) {
            DebtorSale sale = (DebtorSale)saleIt.next();
            while (sale.isPaid() && saleIt.hasNext()) {
                sale = (DebtorSale)saleIt.next();
            }
            if (sale.isPaid()) break;
            DebtorPayment.sortPaymentsForSettlement(this.unsettledPayments);
            if (this.unsettledPayments.size() == 0 && !sale.isPaid()) {
                sale.updatePaid();
            }
            while (this.unsettledPayments.size() > 0) {
                DebtorPayment payment = (DebtorPayment)this.unsettledPayments.get(0);
                if (!payment.getFinanceTransaction().isActive()) continue;
                if (payment.getAmount().greaterThan(sale.getAmountOutstanding())) {
                    Price residual = payment.getAmount().subtract(sale.getAmountOutstanding());
                    payment.setAmount(sale.getAmountOutstanding());
                    payment.setDebtorSale(sale);
                    if (payment.getDebtor() == null) {
                        throw new IllegalStateException("Debtor should not be null in debtor payment");
                    }
                    this.unsettledPayments.set(0, new DebtorPayment(this, payment.getFinanceTransaction(), residual));
                    sale.collapseSalesAccount();
                    saleIt.remove();
                    this.unpaidSales.remove(sale);
                    this.paidSales.add(sale);
                    continue block0;
                }
                if (payment.getAmount().equals(sale.getAmountOutstanding())) {
                    payment.setDebtorSale(sale);
                    this.unsettledPayments.remove(0);
                    sale.collapseSalesAccount();
                    saleIt.remove();
                    this.unpaidSales.remove(sale);
                    this.paidSales.add(sale);
                    continue block0;
                }
                payment.setDebtorSale(sale);
                this.unsettledPayments.remove(0);
            }
        }
    }

    void removeDebtorPaymentsWithFinanceTransaction(FinanceTransaction financeTran) {
        ArrayList<DebtorPayment> debtorPayments = new ArrayList<DebtorPayment>();
        debtorPayments.addAll(financeTran.getDebtorPayments());
        ListIterator it = debtorPayments.listIterator();
        while (it.hasNext()) {
            DebtorPayment payment = (DebtorPayment)it.next();
            it.remove();
            DebtorSale sale = payment.removeSale(this);
            if (sale != null) {
                this.paidSales.remove(sale);
                this.unpaidSales.remove(sale);
                this.unpaidSales.add(sale);
            }
            this.unsettledPayments.remove(payment);
            this.allPayments.remove(payment);
            this.delinkedPayments.add(payment);
        }
    }

    @Override
    public void unlock() {
        this.lock(null);
    }

    @Override
    public boolean lock(User lockUser) {
        if (lockUser == null) {
            this.user.set(null);
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        this.user.set(lockUser);
        return true;
    }

    @Override
    public boolean isLocked(User lockingUser) {
        if (!this.isLocked()) {
            return false;
        }
        return this.getUser().equals(lockingUser);
    }

    @Override
    public boolean relock(User lock) {
        this.user.set(lock);
        return this.getUser().equals(lock);
    }

    @Override
    @Transient
    public boolean isLocked() {
        return this.getUser() != null;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    protected void setPaidSales(List<DebtorSale> sales) {
        this.paidSales = this.paidSales.clone();
        this.paidSales.set(sales);
    }

    protected void setAmountOutstanding(Price amtOutstanding) {
        this.amountOutstanding = amtOutstanding;
    }

    protected void setUnsettledPayments(List<DebtorPayment> payments) {
        this.unsettledPayments = this.unsettledPayments.clone();
        this.unsettledPayments.set(payments);
    }

    protected void setUser(User theUser) {
        this.user.set(theUser);
    }

    protected void setLastActivityDate(Date activityDate) {
        this.lastActivityDate = activityDate;
    }

    protected void setEarliestDueDate(Date earliestDue) {
        this.earliestDueDate = earliestDue;
    }

    protected void setAllPayments(List<DebtorPayment> payments) {
        this.allPayments = this.allPayments.clone();
        this.allPayments.set(payments);
    }

    protected void setUnpaidSales(List<DebtorSale> sales) {
        this.unpaidSales = this.unpaidSales.clone();
        this.unpaidSales.set(sales);
    }

    @Column(name="is_note_required")
    public boolean isNoteRequired() {
        return this.noteRequired;
    }

    public void setNoteRequired(boolean noteRequired) {
        this.noteRequired = noteRequired;
    }

    @Override
    @Transient
    public boolean isCreditLimitChangeAllowed() {
        return true;
    }

    public static class Terms {
        public static final String COD_STRING = "C.O.D.";
        public static final String ON_HOLD_STRING = "On Hold";
        public static final String PRE_PAID_STRING = "Pre Paid";
        public static final int COD = 0;
        public static final int ON_HOLD = -1;
        public static final int PRE_PAID = -2;
        public static final Terms DEFAULT_TERMS = new Terms(0);
        private int terms = 30;

        public Terms(int days) {
            this.terms = days;
        }

        public int getDays() {
            return this.terms;
        }

        public void setTerms(int days) {
            this.terms = days;
        }

        public boolean isOverdue(DebtorSale sale, Date date) {
            if (this.terms == -1) {
                return true;
            }
            if (this.terms == 0) {
                return !sale.isPaid();
            }
            if (this.terms == -2) {
                return !sale.isPaid();
            }
            long diff = date.getTime() - sale.getSaleDate().getTime();
            long termsSeconds = (long)this.getDays() * 86400000L;
            return !sale.isPaid() && diff > termsSeconds;
        }

        public String toString() {
            if (this.terms == -1) {
                return ON_HOLD_STRING;
            }
            if (this.terms == 0) {
                return COD_STRING;
            }
            if (this.terms == -2) {
                return PRE_PAID_STRING;
            }
            String text = this.terms + " Days";
            return text;
        }

        public boolean hasCustomer() {
            return false;
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<DebtorSale> PAID_SALES;
        public PropertiedObject.Property<DebtorSale> UNPAID_SALES;
        public PropertiedObject.Property LAST_ACTIVITY_DATE;
        public PropertiedObject.Property EARLIEST_DUE_DATE;
        public PropertiedObject.Property<DebtorPayment> UNSETTLED_PAYMENTS;
        public PropertiedObject.Property CREDIT_LIMIT;
        public PropertiedObject.Property AMOUNT_OUTSTANDING;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<DebtorGroup> GROUP;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<DebtorPayment> ALL_PAYMENTS;
        public PropertiedObject.Property NOTE_REQUIRED;
    }
}

