/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Transient;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorAgent;
import ordermate.database.finance.debtors.transactions.DebtorSale;

public abstract class AbstractDelegatingDebtorAgent
implements DebtorAgent,
Displayable,
CreditLimited {
    private final AbstractDebtor debtor;
    private List<DebtorSale> selectedSales = new ArrayList<DebtorSale>();

    public AbstractDelegatingDebtorAgent(AbstractDebtor theDebtor) {
        this.debtor = theDebtor;
    }

    @Override
    public AbstractDebtor getDebtor() {
        return this.debtor;
    }

    @Override
    public void delete() {
        this.getDebtor().delete();
    }

    @Override
    public boolean hasChanged() {
        return this.getDebtor().hasChanged();
    }

    @Override
    public void prepareForSave(SaveContext context) {
        this.getDebtor().prepareForSave(context);
    }

    @Override
    public void save() {
        this.getDebtor().save();
    }

    @Override
    public Color getBackgroundColor() {
        return this.getDebtor().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        return this.getDebtor().getForegroundColor();
    }

    @Override
    public String getIcon() {
        return this.getDebtor().getIcon();
    }

    @Override
    public String getLabel() {
        return this.getDebtor().getLabel();
    }

    public String toString() {
        return this.getLabel();
    }

    public void setSelectedSales(Collection<DebtorSale> selectedDebtorSales) {
        this.selectedSales.clear();
        this.selectedSales.addAll(selectedDebtorSales);
    }

    public List<DebtorSale> getSelectedSales() {
        return this.selectedSales;
    }

    public void clearSelectedSales() {
        this.selectedSales.clear();
    }

    @Override
    public boolean exceedsCreditLimit(Price newSaleAmount) {
        return this.getDebtor().exceedsCreditLimit(newSaleAmount);
    }

    @Override
    public Price getCreditLimit() {
        return this.getDebtor().getCreditLimit();
    }

    @Override
    public Price getCreditLimitRemaining() {
        return this.getDebtor().getCreditLimitRemaining();
    }

    @Override
    public void setCreditLimit(Price newLimit) {
        this.getDebtor().setCreditLimit(newLimit);
    }

    @Override
    public Long getID() {
        return this.getDebtor().getID();
    }

    public Class getObjectType() {
        return this.getDebtor().getObjectType();
    }

    @Override
    public boolean isPersistent() {
        return this.getDebtor().isPersistent();
    }

    @Override
    @Transient
    public boolean isCreditLimitChangeAllowed() {
        return true;
    }
}

