/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;

public class DebtorActivityAgent
implements Serializable {
    private final AbstractDebtor debtor;
    private final Set<DebtorSale> debtorSales = new HashSet<DebtorSale>();
    private final Set<DebtorPayment> debtorPayments = new HashSet<DebtorPayment>();
    private final Set<FinanceTransaction> financeTransactions = new HashSet<FinanceTransaction>();
    private Date currentDateTo;
    private Date currentDateFrom;
    private Date date30;
    private Date date60;
    private Price outstanding = Price.ZERO_DOLLAR;
    private Price current = Price.ZERO_DOLLAR;
    private Price due30days = Price.ZERO_DOLLAR;
    private Price due60days = Price.ZERO_DOLLAR;
    private Price dueOver60days = Price.ZERO_DOLLAR;

    public DebtorActivityAgent(AbstractDebtor debtor) {
        this.debtor = debtor;
    }

    public void rollBack(Date revertToDateUpper, Date revertToDateLower) {
        this.currentDateTo = new Date(revertToDateUpper.getTime());
        this.currentDateFrom = new Date(revertToDateLower.getTime());
        this.debtorPayments.clear();
        this.debtorSales.clear();
        this.outstanding = Price.ZERO_DOLLAR;
        this.current = Price.ZERO_DOLLAR;
        this.due30days = Price.ZERO_DOLLAR;
        this.due60days = Price.ZERO_DOLLAR;
        this.dueOver60days = Price.ZERO_DOLLAR;
        this.setDates();
        this.processSales();
        this.processPayments();
        this.processOutstanding();
    }

    public AbstractDebtor getDebtor() {
        return this.debtor;
    }

    public Date getDate() {
        return new Date(this.currentDateTo.getTime());
    }

    public Set getDebtorPayments() {
        return this.debtorPayments;
    }

    public Set getDebtorSales() {
        return this.debtorSales;
    }

    public Set getFinanceTransactions() {
        return this.financeTransactions;
    }

    public Price getOutstanding() {
        return this.outstanding;
    }

    public Price getCurrent() {
        return this.current;
    }

    public Price getDue30Days() {
        return this.due30days;
    }

    public Price getDue60Days() {
        return this.due60days;
    }

    public Price getDueOver60Days() {
        return this.dueOver60days;
    }

    private void addToAgeingBalance(Price amountOutstanding, Date dueDate) {
        if (amountOutstanding.isZero()) {
            return;
        }
        if (dueDate.compareTo(this.currentDateFrom) >= 0 && dueDate.compareTo(this.currentDateTo) <= 0) {
            this.current = this.current.add(amountOutstanding);
        } else if (dueDate.compareTo(this.date30) >= 0) {
            this.due30days = this.due30days.add(amountOutstanding);
        } else if (dueDate.compareTo(this.date60) >= 0) {
            this.due60days = this.due60days.add(amountOutstanding);
        } else {
            this.dueOver60days = this.dueOver60days.add(amountOutstanding);
        }
    }

    private void processOutstanding() {
        for (DebtorSale sale : this.debtorSales) {
            this.outstanding = this.outstanding.add(sale.getAmountOutstanding());
            this.addToAgeingBalance(sale.getAmountOutstanding(), sale.getDueDate());
        }
        for (DebtorPayment payment : this.debtorPayments) {
            if (payment.getSale() != null && this.debtorSales.contains(payment.getSale())) continue;
            Price amount = Price.ZERO_DOLLAR.subtract(payment.getAmount());
            this.outstanding = this.outstanding.add(amount);
            this.addToAgeingBalance(amount, payment.getDate());
        }
    }

    private void processPayments() {
        for (DebtorPayment payment : this.debtor.getAllPayments()) {
            if (payment.getDate().compareTo(this.currentDateTo) > 0) continue;
            this.debtorPayments.add(payment);
            this.financeTransactions.add(payment.getFinanceTransaction());
        }
    }

    private void processSales() {
        ArrayList<DebtorPayment> tooRecent = new ArrayList<DebtorPayment>();
        for (DebtorSale sale : this.debtor.getAllSales()) {
            if (sale.getSaleDate().compareTo(this.currentDateTo) > 0) continue;
            this.debtorSales.add(sale);
            for (DebtorPayment payment : sale.getPayments()) {
                if (payment.getDate().compareTo(this.currentDateTo) <= 0) {
                    this.debtorPayments.add(payment);
                    continue;
                }
                tooRecent.add(payment);
            }
            for (DebtorPayment payment : tooRecent) {
                sale.removePayment(payment, this.debtor);
            }
            tooRecent.clear();
        }
    }

    private void setDates() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currentDateFrom);
        cal.add(5, -30);
        this.date30 = cal.getTime();
        cal.add(5, -30);
        this.date60 = cal.getTime();
    }
}

