/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.SingletonReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="debtor_config_system")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class DebtorConfig
extends PersistentObject
implements Saveable {
    private static final int DEFAULT_DAYS_PAID_SALES = 7;
    private static final String DEFAULT_STMT_CHARGES_COL_TITLE = "Charges";
    private static final String DEFAULT_STMT_PAYMENTS_COL_TITLE = "Payments";
    private static final String DEFAULT_STMT_BALANCE_COL_TITLE = "Balance";
    private static final String DEFAULT_STMT_INVOICE_NUM_COL_TITLE = "Invoice No.";
    private static final String DEFAULT_STMT_SALE_DATE_COL_TITLE = "Sale Date";
    private static final String DEFAULT_STMT_DESCRIPTION_COL_TITLE = "Description";
    private static final String DEFAULT_STMT_REPORT_LOCATION = "/ordermate/reports/printing/StatementPrintDataReport.jrxml";
    private static final String DEFAULT_SUMMARY_REPORT_LOCATION = "/ordermate/reports/printing/DebtorsSummaryReport.jrxml";
    public static final Props Properties = new Props();
    private String daysPaidSalesToShow;
    private String stmtColTitleCharges = null;
    private String stmtColTitlePayments = null;
    private String stmtColTitleBalance = null;
    private String stmtColTitleInvoiceNum = null;
    private String stmtColTitleSaleDate = null;
    private String stmtColTitleDescription = null;
    private String summaryReportLocation = null;
    private String statementReportLocation = null;
    private static Reference instance = new LocalCachedReference<DebtorConfig>(new SingletonReference<DebtorConfig>(DebtorConfig.class));

    public static final DebtorConfig getInstance() {
        return (DebtorConfig)instance.get();
    }

    @Column(name="stmtColTitleInvoiceNum")
    public String getStmtColTitleInvoiceNum() {
        if (this.stmtColTitleInvoiceNum == null) {
            this.stmtColTitleInvoiceNum = DEFAULT_STMT_INVOICE_NUM_COL_TITLE;
            this.save();
        }
        return this.stmtColTitleInvoiceNum;
    }

    public void setStmtColTitleInvoiceNum(String newStmtColTitleInvoiceNum) {
        this.stmtColTitleInvoiceNum = newStmtColTitleInvoiceNum;
    }

    @Column(name="stmtColTitleCharges")
    public String getStmtColTitleCharges() {
        if (this.stmtColTitleCharges == null) {
            this.stmtColTitleCharges = DEFAULT_STMT_CHARGES_COL_TITLE;
            this.save();
        }
        return this.stmtColTitleCharges;
    }

    public void setStmtColTitleCharges(String newStmtColTitleCharges) {
        this.stmtColTitleCharges = newStmtColTitleCharges;
    }

    @Column(name="stmtColTitlePayments")
    public String getStmtColTitlePayments() {
        if (this.stmtColTitlePayments == null) {
            this.stmtColTitlePayments = DEFAULT_STMT_PAYMENTS_COL_TITLE;
            this.save();
        }
        return this.stmtColTitlePayments;
    }

    public void setStmtColTitlePayments(String newSmtColTitlePayments) {
        this.stmtColTitlePayments = newSmtColTitlePayments;
    }

    @Column(name="stmtColTitleBalance")
    public String getStmtColTitleBalance() {
        if (this.stmtColTitleBalance == null) {
            this.stmtColTitleBalance = DEFAULT_STMT_BALANCE_COL_TITLE;
            this.save();
        }
        return this.stmtColTitleBalance;
    }

    public void setStmtColTitleBalance(String newStmtColTitleBalance) {
        this.stmtColTitleBalance = newStmtColTitleBalance;
    }

    @Column(name="stmtColTitleSaleDate")
    public String getStmtColTitleSaleDate() {
        if (this.stmtColTitleSaleDate == null) {
            this.stmtColTitleSaleDate = DEFAULT_STMT_SALE_DATE_COL_TITLE;
            this.save();
        }
        return this.stmtColTitleSaleDate;
    }

    public void setStmtColTitleSaleDate(String newStmtColTitleSaleDate) {
        this.stmtColTitleSaleDate = newStmtColTitleSaleDate;
    }

    @Column(name="stmtColTitleDescription")
    public String getStmtColTitleDescription() {
        if (this.stmtColTitleDescription == null) {
            this.stmtColTitleDescription = DEFAULT_STMT_DESCRIPTION_COL_TITLE;
            this.save();
        }
        return this.stmtColTitleDescription;
    }

    public void setStmtColTitleDescription(String newStmtColTitleDescription) {
        this.stmtColTitleDescription = newStmtColTitleDescription;
    }

    @Column(name="days_paid_sales_to_show")
    public String getDaysPaidSalesToShow() {
        try {
            int daysPaid = Integer.parseInt(this.daysPaidSalesToShow);
            return this.daysPaidSalesToShow;
        }
        catch (NumberFormatException ex) {
            this.daysPaidSalesToShow = Integer.toString(7);
            this.save();
            return "7";
        }
    }

    @Column(name="summaryReportLocation")
    public String getSummaryReportLocation() {
        if (this.summaryReportLocation != null) {
            return this.summaryReportLocation;
        }
        return DEFAULT_SUMMARY_REPORT_LOCATION;
    }

    public void setSummaryReportLocation(String newSummaryReportLocation) {
        this.summaryReportLocation = newSummaryReportLocation;
    }

    @Column(name="statementReportLocation")
    public String getStatementReportLocation() {
        if (this.statementReportLocation != null) {
            return this.statementReportLocation;
        }
        return DEFAULT_STMT_REPORT_LOCATION;
    }

    public void setStatementReportLocation(String newStatementReportLocation) {
        this.statementReportLocation = newStatementReportLocation;
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    protected void setDaysPaidSalesToShow(String daysPaidSalesToShow) {
        this.daysPaidSalesToShow = daysPaidSalesToShow;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DAYS_PAID_SALES_TO_SHOW;
        public PropertiedObject.Property STMT_COL_TITLE_CHARGES;
        public PropertiedObject.Property STMT_COL_TITLE_BALANCE;
        public PropertiedObject.Property STMT_COL_TITLE_INVOICE_NUM;
        public PropertiedObject.Property STMT_COL_TITLE_PAYMENTS;
        public PropertiedObject.Property STMT_COL_TITLE_SALE_DATE;
        public PropertiedObject.Property STMT_COL_TITLE_DESCRIPTION;
        public PropertiedObject.Property SUMMARY_REPORT_LOCATION;
        public PropertiedObject.Property STATEMENT_REPORT_LOCATION;
    }
}

