/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.PayableHelper;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.AbstractDelegatingDebtorAgent;
import ordermate.database.finance.debtors.DebtorAgent;
import ordermate.database.finance.debtors.DebtorPaymentRefundAgent;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.ExportTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.misc.TerminalEventLog;

public class DebtorPaymentAgent
extends AbstractDelegatingDebtorAgent
implements DebtorAgent,
Payable {
    private List<FinanceTransaction> localFinanceTransactions = new ArrayList<FinanceTransaction>();
    private List<FinanceTransaction> removedFinanceTransactions = new ArrayList<FinanceTransaction>();

    public DebtorPaymentAgent(AbstractDebtor newDebtor) {
        this(newDebtor, newDebtor.getUnpaidSales());
    }

    public DebtorPaymentAgent(AbstractDebtor newDebtor, List<DebtorSale> useTheseSales) {
        super(newDebtor);
        this.setSelectedSales(useTheseSales);
    }

    @Override
    public void addFinanceTransaction(FinanceTransaction transaction) {
        this.localFinanceTransactions.add(transaction);
        this.removedFinanceTransactions.remove(transaction);
    }

    @Override
    public boolean allowsPayingIntoCredit() {
        return true;
    }

    @Override
    public Price getDue() {
        return this.getDue(0.01);
    }

    @Override
    public Price getDue(double roundAmt) {
        return this.getTotal().subtract(this.getPaid());
    }

    @Override
    public List<FinanceTransaction> getFinanceTransactions() {
        return this.localFinanceTransactions;
    }

    @Override
    public Price getPaid() {
        Price paid = new Price(0.0, 0.01);
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        for (FinanceTransaction payment : payments) {
            paid = paid.add(payment.getPaid());
        }
        return paid;
    }

    @Override
    public Payable.PaidState getPaidState() {
        if (this.getDue().greaterThan(Price.ZERO_DOLLAR)) {
            return NOT_PAID;
        }
        if (this.getDue().lessThan(Price.ZERO_DOLLAR)) {
            return CREDIT;
        }
        return PAID;
    }

    @Override
    public Price getTendered() {
        Price tendered = Price.ZERO_DOLLAR;
        List<FinanceTransaction> payments = this.getFinanceTransactions();
        for (FinanceTransaction payment : payments) {
            tendered = new Price(tendered.doubleValue() + payment.getTendered().doubleValue(), 0.01);
        }
        return tendered;
    }

    @Override
    public Price getTotal() {
        Price total = Price.ZERO_DOLLAR;
        for (DebtorSale sale : this.getSelectedSales()) {
            total = total.add(sale.getDue());
        }
        return total.subtract(this.getDebtor().getTotalUnsettledPayments());
    }

    @Override
    public void pay() {
        for (FinanceTransaction tran : this.getFinanceTransactions()) {
            this.getDebtor().addPayment(tran, tran.getPaid());
            TerminalEventLog.getInst().logDebtorTransaction(new EventContext(tran.getTerminal(), tran.getUser()), this.getDebtor(), tran);
        }
        this.localFinanceTransactions.clear();
        this.getDebtor().settleSales(this.getSelectedSales());
        this.save();
        this.saveRemovedTransactions();
    }

    public void saveRemovedTransactions() {
        if (this.removedFinanceTransactions.size() > 0) {
            DebtorPaymentRefundAgent agent = new DebtorPaymentRefundAgent(this.getDebtor());
            ArrayList<FinanceTransaction> toReverse = new ArrayList<FinanceTransaction>();
            for (FinanceTransaction txn : this.removedFinanceTransactions) {
                if (txn instanceof EftposTransaction && txn.isActive()) {
                    if (txn.isPersistent()) {
                        EftposTransaction reversal = ((EftposTransaction)txn).createReverseTransaction();
                        agent.addFinanceTransaction(reversal);
                        toReverse.add(txn);
                        continue;
                    }
                    txn.setSystemState("DELETED");
                    txn.saveChild();
                    continue;
                }
                txn.prepareForSave(new EventContext(txn.getTerminal(), txn.getUser()));
                txn.deleteChild();
            }
            if (toReverse.size() > 0) {
                agent.refundFinanceTransactions(toReverse, new EventContext(((FinanceTransaction)toReverse.get(0)).getUser()));
                agent.pay();
            }
        }
    }

    @Override
    public void removeFinanceTransaction(FinanceTransaction toRemove) {
        if (!this.localFinanceTransactions.remove(toRemove)) {
            throw new IllegalStateException("Attempt to remove finance transaction that is not in the list of local finance transactions");
        }
        this.removedFinanceTransactions.add(toRemove);
    }

    @Override
    public boolean isPaidModifiable() {
        return true;
    }

    public void addExportTransaction(Price amount, EventContext context) {
        ExportTransaction tran = new ExportTransaction(amount, new FinanceTransactionContext(context, null));
        this.addFinanceTransaction(tran);
    }

    @Override
    public List<FinanceTransactionDocket> getEftposDockets() {
        List<FinanceTransactionDocket> dockets = PayableHelper.getEftposDockets(this.localFinanceTransactions);
        dockets.addAll(PayableHelper.getEftposDockets(this.removedFinanceTransactions));
        return dockets;
    }

    @Override
    public boolean hasEftposDockets() {
        return PayableHelper.hasEftposDockets(this.localFinanceTransactions) || PayableHelper.hasEftposDockets(this.removedFinanceTransactions);
    }
}

