/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.misc.TerminalEventLog;

public class DebtorPaymentRefundAgent
extends DebtorPaymentAgent {
    private final List<FinanceTransaction> refundedTransaction = new ArrayList<FinanceTransaction>();

    public DebtorPaymentRefundAgent(AbstractDebtor theDebtor) {
        super(theDebtor);
    }

    public void refundFinanceTransactions(List<FinanceTransaction> financeTransactions, EventContext context) {
        FinanceTransaction transaction;
        Price total = Price.ZERO_DOLLAR;
        HashSet<DebtorSale> allSales = new HashSet<DebtorSale>();
        for (FinanceTransaction txn : financeTransactions) {
            if (txn.isRefundedDebtorPayment() || !"ACTIVE".equals(txn.getSystemState()) || txn.getPaid().lessThan(Price.ZERO_DOLLAR)) continue;
            this.refundedTransaction.add(txn);
            if (txn.getType().equals("ACCOUNT")) {
                total = total.add(txn.getPaid());
            }
            allSales.addAll(txn.getDebtorSales());
            this.getDebtor().removeDebtorPaymentsWithFinanceTransaction(txn);
            TerminalEventLog.getInst().logDebtorTransactionRefund(context, this.getDebtor(), txn);
            this.addFinanceTransaction(txn);
        }
        this.setSelectedSales(allSales);
        if (total.doubleValue() > 0.0) {
            transaction = DebtorAdjustmentTransaction.createDebtorSurchargeTransaction(new FinanceTransactionContext(context), total);
            this.addFinanceTransaction(transaction);
        } else if (total.doubleValue() < 0.0) {
            total = total.multiply(-1);
            transaction = DebtorAdjustmentTransaction.createDebtorDiscountTransaction(new FinanceTransactionContext(context), total);
            this.addFinanceTransaction(transaction);
        }
    }

    @Override
    public Price getTotal() {
        return Price.ZERO_DOLLAR;
    }

    @Override
    public void save() {
        for (FinanceTransaction tran : this.refundedTransaction) {
            for (DebtorPayment currentDPay : tran.getDebtorPayments()) {
                currentDPay.markAsRefunded();
            }
        }
        super.save();
    }
}

