/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.AbstractDelegatingDebtorAgent;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.RefundAccount;
import ordermate.database.sales.SalesAdjustmentsTransfer;
import ordermate.database.sales.SalesLineItem;

public class DebtorSalesRefundAgent
extends AbstractDelegatingDebtorAgent {
    public DebtorSalesRefundAgent(AbstractDebtor theDebtor, List selectedDebtorSales) {
        super(theDebtor);
        this.setSelectedSales(selectedDebtorSales);
    }

    public DebtorSale addRefundSale(RefundAccount refund, List<SalesLineItem> itemsToRefund, FinanceTransactionContext context, String invoiceNote) {
        List<DebtorSale> debtorSales = this.refundItems(itemsToRefund, refund, context);
        refund.close(context);
        refund.save();
        DebtorSale refundSale = this.getDebtor().addSale(refund, context, invoiceNote);
        debtorSales.add(refundSale);
        FinanceTransaction adjustment = DebtorAdjustmentTransaction.createZeroDollarLinkingTransaction(context);
        this.getDebtor().addPayment(adjustment, Price.ZERO_DOLLAR);
        this.getDebtor().settleSales(debtorSales);
        return refundSale;
    }

    private List<DebtorSale> refundItems(List<SalesLineItem> itemsToRefund, RefundAccount refund, FinanceTransactionContext context) {
        ArrayList<DebtorSale> refundedDebtorSales = new ArrayList<DebtorSale>();
        for (DebtorSale currentSale : this.getSelectedSales()) {
            if (currentSale.itemsAreASubSetOfTheseItems(itemsToRefund)) {
                currentSale.markAllRefunded();
            } else {
                if (!currentSale.hasAnItemInList(itemsToRefund)) continue;
                currentSale.markSomeRefunded();
            }
            SalesAdjustmentsTransfer trf = new SalesAdjustmentsTransfer(SalesAdjustmentsTransfer.REFUND, currentSale.getSaleAccount(), refund, itemsToRefund, context);
            trf.transferAccountPercentageAdjustment();
            trf.transferAccountAmountAdjustment();
            TerminalEventLog.getInst().logDebtorSaleRefund(context, this.getDebtor(), currentSale);
            refundedDebtorSales.add(currentSale);
        }
        return refundedDebtorSales;
    }

    public RefundAccount createRefundAccount(List<SalesLineItem> itemsToRefund, EventContext context) {
        RefundAccount refund = new RefundAccount(context);
        refund.lock(context.getUser());
        refund.addItems(itemsToRefund, context);
        refund.close(context);
        return refund;
    }

    public void refund() {
        DebtorPaymentAgent payable = new DebtorPaymentAgent(this.getDebtor());
        payable.setSelectedSales(this.getSelectedSales());
        payable.pay();
    }
}

