/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.AbstractDelegatingDebtorAgent;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;

public class DebtorTransferAgent
extends AbstractDelegatingDebtorAgent {
    public DebtorTransferAgent(AbstractDebtor debtor) {
        super(debtor);
    }

    public DebtorTransferAgent(AbstractDebtor debtor, List<DebtorSale> selectedDebtorSales) {
        super(debtor);
        this.setSelectedSales(selectedDebtorSales);
    }

    public Price getTransferSaleTotal() {
        Price total = Price.ZERO_DOLLAR;
        for (DebtorSale sale : this.getSelectedSales()) {
            total = total.add(sale.getAmount());
        }
        return total;
    }

    public final void transferSales(AbstractDebtor destinationDebtor, List<DebtorSale> selectedSales, EventContext context) {
        if (selectedSales.size() == 0) {
            return;
        }
        this.setSelectedSales(selectedSales);
        ArrayList<Account> transferredSalesForLog = new ArrayList<Account>();
        for (DebtorSale sale : this.getSelectedSales()) {
            for (DebtorPayment payment : new ArrayList<DebtorPayment>(sale.getPayments())) {
                payment.removeSale(payment.getDebtor());
                this.getDebtor().addUnsettledPayment(payment);
            }
            this.getDebtor().removeSale(sale);
            this.transferSale(destinationDebtor, sale);
            this.getDebtor().save();
            transferredSalesForLog.add(sale.getSaleAccount());
        }
        this.payDebtors(this.getDebtor(), destinationDebtor);
        TerminalEventLog.getInst().logDebtorSalesAccountTransfer(context, this.getDebtor(), destinationDebtor, transferredSalesForLog);
    }

    private void transferSale(AbstractDebtor destination, DebtorSale sale) {
        sale.removeAllPayments();
        destination.addDebtorSale(sale);
    }

    public final void transferPayments(AbstractDebtor destinationDebtor, List<DebtorPayment> payments, EventContext context) {
        ArrayList<FinanceTransaction> transferredTransactions = new ArrayList<FinanceTransaction>();
        for (DebtorPayment currentPayment : payments) {
            FinanceTransaction currentTransaction = currentPayment.getFinanceTransaction();
            this.getDebtor().removeDebtorPaymentsWithFinanceTransaction(currentTransaction);
            destinationDebtor.addPayment(currentTransaction, currentTransaction.getPaid());
            transferredTransactions.add(currentTransaction);
        }
        this.payDebtors(this.getDebtor(), destinationDebtor);
        TerminalEventLog.getInst().logDebtorFinanceTransactionTransfer(context, this.getDebtor(), destinationDebtor, transferredTransactions);
    }

    private void payDebtors(AbstractDebtor source, AbstractDebtor destinationDebtor) {
        this.clearSelectedSales();
        DebtorPaymentAgent payable = new DebtorPaymentAgent(this.getDebtor());
        payable.pay();
        payable = new DebtorPaymentAgent(destinationDebtor);
        payable.pay();
        this.save();
    }
}

