/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;

public class DebtorsSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Price outstanding = new Price(0.0, 0.0);
    private Price overdue = new Price(0.0, 0.0);
    private Price current = new Price(0.0, 0.0);
    private Price thirtyDays = new Price(0.0, 0.0);
    private Price sixtyDays = new Price(0.0, 0.0);
    private Price sixtyPlusDays = new Price(0.0, 0.0);
    List debtors;

    public static DebtorsSummary summarize(AbstractDebtor debtor) {
        ArrayList<AbstractDebtor> list = new ArrayList<AbstractDebtor>();
        list.add(debtor);
        return DebtorsSummary.summarize(list);
    }

    public static DebtorsSummary summarize(List debtors) {
        DebtorsSummary summary = new DebtorsSummary();
        summary.setDebtors(debtors);
        List<DebtorsSummary> objectList = PersistenceManager.getObjectList(DebtorsSummary.class, summary.getQuery(), new Object[0]);
        if (objectList == null || objectList.size() < 1) {
            return new DebtorsSummary();
        }
        if (objectList.size() > 1) {
            return DebtorsSummary.subtract(objectList.get(0), objectList.get(1));
        }
        return objectList.get(0);
    }

    private static DebtorsSummary subtract(DebtorsSummary s1, DebtorsSummary s2) {
        DebtorsSummary sub1 = s1;
        if (s2 == null) {
            return s1;
        }
        if (s1 == null) {
            sub1 = new DebtorsSummary();
        }
        DebtorsSummary sum = new DebtorsSummary();
        sum.outstanding = sub1.getOutstanding().subtract(s2.getOutstanding());
        sum.overdue = sub1.getOverdue().subtract(s2.getOverdue());
        sum.current = sub1.getCurrent().subtract(s2.getCurrent());
        sum.thirtyDays = sub1.getThirtyDays().subtract(s2.getThirtyDays());
        sum.sixtyDays = sub1.getSixtyDays().subtract(s2.getSixtyDays());
        sum.sixtyPlusDays = sub1.getSixtyPlusDays().subtract(s2.getSixtyPlusDays());
        return sum;
    }

    public Price getOutstanding() {
        if (this.outstanding == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.outstanding;
    }

    public Price getOverdue() {
        if (this.overdue == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.overdue;
    }

    public Price getCurrent() {
        if (this.current == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.current;
    }

    public Price getThirtyDays() {
        if (this.thirtyDays == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.thirtyDays;
    }

    public Price getSixtyDays() {
        if (this.sixtyDays == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.sixtyDays;
    }

    public Price getSixtyPlusDays() {
        if (this.sixtyPlusDays == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.sixtyPlusDays;
    }

    @Override
    public String toString() {
        return "Outstanding: " + this.outstanding + "   Overdue:" + this.overdue + "   Current:" + this.current + "   30days " + this.thirtyDays + "   60Days" + this.sixtyDays + "   60+Days" + this.sixtyPlusDays;
    }

    public void setDebtors(List newDebtors) {
        this.debtors = newDebtors;
        Object[] params = new Object[newDebtors.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((PersistentObjectI)this.debtors.get(i)).getID();
        }
        this.setParameters(params);
    }

    protected ObjectQuery getSummaryQuery() {
        ObjectQuery query = Query.selectFunc("IFNULL( SUM( " + DebtorSale.Properties.AMOUNT_OUTSTANDING + "),0) AS outstanding").selectFunc("SUM(IF(" + DebtorSale.Properties.DUE_DATE + "<  CURDATE(), " + DebtorSale.Properties.AMOUNT_OUTSTANDING + ", 0)) AS overdue").selectFunc("SUM(IF(" + DebtorSale.Properties.DUE_DATE + " >=  CURDATE(), " + DebtorSale.Properties.AMOUNT_OUTSTANDING + ", 0)) AS current").selectFunc("SUM(IF(" + DebtorSale.Properties.DUE_DATE + ">= DATE_SUB(CURDATE(), INTERVAL 30 Day) AND " + DebtorSale.Properties.DUE_DATE + " <  CURDATE(), " + DebtorSale.Properties.AMOUNT_OUTSTANDING + ", 0)) AS thirtyDays").selectFunc("SUM(IF(" + DebtorSale.Properties.DUE_DATE + ">= DATE_SUB(CURDATE(), INTERVAL 60 Day) AND " + DebtorSale.Properties.DUE_DATE + " <  DATE_SUB(CURDATE(), INTERVAL 30 DAY), " + DebtorSale.Properties.AMOUNT_OUTSTANDING + ", 0)) AS sixtyDays").selectFunc("SUM(IF(" + DebtorSale.Properties.DUE_DATE + " < DATE_SUB(CURDATE(), INTERVAL 60 DAY), " + DebtorSale.Properties.AMOUNT_OUTSTANDING + ", 0)) AS sixtyPlusDays").equals(DebtorSale.Properties.PAID, false).equals(DebtorSale.Properties.EXPORTED, false);
        if (this.getParamCount() > 0) {
            query = query.wherePropertyIn(DebtorSale.Properties.DEBTOR, this.debtors);
        }
        ObjectQuery paymentQuery = Query.selectFunc("IFNULL( SUM( " + DebtorPayment.Properties.AMOUNT + "),0) As outstanding").select("0", "overdue").select("0", "current").select("0", "thirtyDays").select("0", "sixtyDays").select("0", "sixtyPlusDays").isNull(DebtorPayment.Properties.SALE).linkUsing(DebtorPayment.Properties.DEBTOR);
        if (this.getParamCount() > 0) {
            paymentQuery = paymentQuery.wherePropertyIn(DebtorPayment.Properties.DEBTOR, this.debtors);
        }
        query = query.union(paymentQuery);
        return query;
    }

    protected String getQuery() {
        return this.getSummaryQuery().toString();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property OUTSTANDING;
        public PropertiedObject.Property OVERDUE;
        public PropertiedObject.Property CURRENT;
        public PropertiedObject.Property THIRTY_DAYS;
        public PropertiedObject.Property SIXTY_DAYS;
        public PropertiedObject.Property SIXTY_PLUS_DAYS;
    }
}

