/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.finance.debtors.activitystatement;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorActivityAgent;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.print.ActivityStatementData;

public class ActivityStatement {
    private final AbstractDebtor debtor;
    private final Date from;
    private final Date to;
    private final DebtorActivityAgent agent;
    private Price openingBalance;
    private final List<ActivityStatementData> printData = new ArrayList<ActivityStatementData>();

    public ActivityStatement(AbstractDebtor newDebtor, Date newFrom, Date newTo) {
        this.debtor = newDebtor;
        this.from = new Date(DateTimeUtils.getStartOfDay(newFrom).getTime());
        this.to = new Date(DateTimeUtils.getEndOfDay(newTo).getTime());
        this.agent = new DebtorActivityAgent(newDebtor);
        this.agent.rollBack(this.to, this.from);
        this.openingBalance = this.agent.getOutstanding();
        this.processSales();
        this.processPayments();
        this.setBalance();
    }

    public Date getFrom() {
        return new Date(this.from.getTime());
    }

    public Date getTo() {
        return new Date(this.to.getTime());
    }

    public AbstractDebtor getDebtor() {
        return this.debtor;
    }

    public Price getOpeningBalance() {
        return this.openingBalance;
    }

    public Price getAmountAt30() {
        return this.agent.getDue30Days();
    }

    public Price getAmountAt60() {
        return this.agent.getDue60Days();
    }

    public Price getAmountAt60Plus() {
        return this.agent.getDueOver60Days();
    }

    public Price getAmountCurrent() {
        return this.agent.getCurrent();
    }

    public Price getAmountDue() {
        return this.agent.getOutstanding();
    }

    public Collection getPrintData() {
        return this.printData;
    }

    private void setBalance() {
        Collections.sort(this.printData, new ActivityStatementData.TimeOrderComparator());
        double balance = this.openingBalance.doubleValue();
        for (ActivityStatementData data : this.getPrintData()) {
            data.setBalance(balance += data.getSaleAmount() - data.getPaidAmount());
        }
    }

    private void processSales() {
        for (DebtorSale sale : this.agent.getDebtorSales()) {
            if (sale.getSaleDate().compareTo(this.from) < 0) continue;
            this.openingBalance = this.openingBalance.subtract(sale.getAmount());
            ActivityStatementData data = new ActivityStatementData(sale);
            this.printData.add(data);
        }
    }

    private void processPayments() {
        for (FinanceTransaction transaction : this.agent.getFinanceTransactions()) {
            if (transaction.getCreationTime().compareTo(this.from) < 0) continue;
            ActivityStatementData data = new ActivityStatementData(transaction);
            this.printData.add(data);
            this.openingBalance = this.openingBalance.add(transaction.getPaid());
        }
    }
}

